/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.CheckSumThread;
import com.clustercontrol.agent.CommandThread;
import com.clustercontrol.agent.FileListThread;
import com.clustercontrol.agent.PublicKeyThread;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveTopic
implements MessageListener,
ExceptionListener {
    private static long RETRY_INTERVAL = 10000L;
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    private static final String TOPIC_USER_NAME = "topic.user.name";
    private static final String TOPIC_USER_PASSWORD = "topic.user.password";
    protected ArrayList m_facilityIdList;
    protected SendQueue m_sendQueue;
    private Properties m_props;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    private boolean m_errFlg = false;
    protected static Timer m_timer = new Timer(true);
    private static Log log = LogFactory.getLog(ReceiveTopic.class);
    static /* synthetic */ Class class$0;

    public ReceiveTopic(Collection facilityIdList, SendQueue sendQueue, Properties props) {
        this.m_facilityIdList = new ArrayList(facilityIdList);
        this.m_sendQueue = sendQueue;
        this.m_props = props;
        this.initial();
    }

    public synchronized void setFacilityIdList(Collection facilityIdList) {
        if (facilityIdList.size() == this.m_facilityIdList.size() && this.m_facilityIdList.containsAll(facilityIdList)) {
            return;
        }
        this.m_facilityIdList = new ArrayList(facilityIdList);
        if (!this.isErrFlg()) {
            this.initialTopic();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        Serializable obj;
        log.debug((Object)"onMessage start");
        if (!(message instanceof ObjectMessage)) {
            log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + message.getClass()));
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            obj = objectMessage.getObject();
        }
        catch (JMSException e) {
            log.error((Object)"\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63", (Throwable)e);
            return;
        }
        if (!(obj instanceof RunInstructionInfo)) {
            log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + obj.toString()));
            return;
        }
        log.debug((Object)"onMessage get RunInstructionInfo");
        RunInstructionInfo info = (RunInstructionInfo)obj;
        log.debug((Object)("onMessage SessionID=" + info.getSessionId() + ", JobID=" + info.getJobId()));
        if (info.getCommandType() == 3) {
            log.debug((Object)"onMessage CommandType = CHECK");
            RunResultInfo resultInfo = new RunResultInfo();
            resultInfo.setSessionId(info.getSessionId());
            resultInfo.setJobId(info.getJobId());
            resultInfo.setFacilityId(info.getFacilityId());
            resultInfo.setCommandType(info.getCommandType());
            this.m_sendQueue.put(resultInfo);
        } else {
            log.debug((Object)"onMessage CommandType != CHECK");
            if (info.getCommand().equals("getPublicKey") || info.getCommand().equals("addPublicKey") || info.getCommand().equals("deletePublicKey")) {
                log.debug((Object)"onMessage CommandType = GET_PUBLIC_KEY or ADD_PUBLIC_KEY or DELETE_PUBLIC_KEY");
                PublicKeyThread thread = new PublicKeyThread(info, this.m_sendQueue, this.m_props);
                thread.start();
            } else if (info.getCommand().equals("getFileList")) {
                log.debug((Object)"onMessage CommandType = GET_FILE_LIST");
                FileListThread thread = new FileListThread(info, this.m_sendQueue, this.m_props);
                thread.start();
            } else if (info.getCommand().equals("getCheckSum") || info.getCommand().equals("checkCheckSum")) {
                log.debug((Object)"onMessage CommandType = GET_CHECKSUM or CHECK_CHECKSUM");
                CheckSumThread thread = new CheckSumThread(info, this.m_sendQueue);
                thread.start();
            } else {
                CommandThread thread = new CommandThread(info, this.m_sendQueue);
                thread.start();
            }
        }
        log.debug((Object)"onMessage end");
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0);
        this.setErrFlg(true);
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            m_timer.schedule((TimerTask)new ReSetupTask(), RETRY_INTERVAL, RETRY_INTERVAL);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean isErrFlg() {
        return this.m_errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            try {
                con = new InitialContext(this.m_props);
                this.m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
                this.m_con = this.m_props.getProperty(TOPIC_USER_NAME) != null ? this.m_factory.createTopicConnection(this.m_props.getProperty(TOPIC_USER_NAME), this.m_props.getProperty(TOPIC_USER_PASSWORD)) : this.m_factory.createTopicConnection();
                this.m_session = this.m_con.createTopicSession(false, 1);
                this.m_topic = (Topic)con.lookup("topic/clustercontrol/JobManagement/execute");
                this.m_con.setExceptionListener((ExceptionListener)this);
                this.m_con.start();
                this.initialTopic();
            }
            catch (Exception e) {
                log.error((Object)"Init", (Throwable)e);
                this.setErrFlg(true);
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            StringBuffer msgSelector = new StringBuffer();
            Iterator iter = this.m_facilityIdList.iterator();
            while (iter.hasNext()) {
                String facilityId = (String)iter.next();
                msgSelector.append("FacilityId='");
                msgSelector.append(facilityId);
                msgSelector.append("'");
                if (!iter.hasNext()) continue;
                msgSelector.append(" OR ");
            }
            if (msgSelector.length() != 0) {
                this.m_subscriber = this.m_session.createSubscriber(this.m_topic, msgSelector.toString(), false);
                this.m_subscriber.setMessageListener((MessageListener)this);
            } else {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u304c\u306a\u3044\u306e\u3067\u3001\u4f55\u3082\u3057\u306a\u3044");
            }
        }
        catch (Exception e) {
            log.error((Object)"TopicInit", (Throwable)e);
            this.setErrFlg(true);
            return false;
        }
        return true;
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (ReceiveTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

