#!/bin/sh

#Copyright (C) 2005 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み
. ${0%/*}/install.cfg
 
EXEC_PATH=${0%/*}


echo ""
                                                                                
echo "###################################################################"
echo "###                                                             ###"
echo "### 運用管理ソフトウェア Hinemos  エージェント                  ###"
echo "###                                   インストーラ   Ver 2.0    ###"
echo "###                                                             ###"
echo "###  2006/3/31                                                  ###"
echo "###  Copyright (C) 2006 NTT DATA Corporation.                   ###"
echo "###################################################################"

echo "注意 このインストールはrootで行って下さい。"

while [ 1 ];
do
  echo "Hinemos エージェント の"
  echo "     1) インストール"
  echo "     2) アンインストール"
  echo "     9) インストーラの終了"
  echo ""
  echo -n "===> "
  
  read CHOSEN_NUMBER
  
  case ${CHOSEN_NUMBER} in
      1)      
	  
	  echo ""
	  echo "エージェントセットアップを行います。"
	  echo ""
	  echo ""

		while [ 1 ];
		  do
		  echo "インストールを開始します。よろしいですか?(Y/N)"
		  read ANS
		  case ${ANS} in
		      y|Y)
			  
			  # インストール準備部分
			  
			  if [ ! -d ${HINEMOS_AGENT_HOME} ]; then
			      echo "${HINEMOS_AGENT_HOME}は存在しません。作成します。"
			      echo "mkdir -p ${HINEMOS_AGENT_HOME}" 
			      echo ""
			  fi

			  while [ ! "${IPADDR}" ] ;
			  do
			      echo -n "マネージャのIPアドレスを入力して下さい："
			      read IPADDR
			  done

			
			  # コピー開始
			  echo "必要なファイルのコピーを開始します。"
			  cp -pr $EXEC_PATH/hinemos_agent /opt
			  echo "必要なファイルのコピーが終了しました。"
			  echo ""


			  # マネージャIPアドレスの反映
			  sed "s/%%manager%%/$IPADDR/" ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp
			  mv -f ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
			  
			  #一括制御機能のセットアップ
				  echo "一括制御機能のセットアップを行なっています。"
				  echo "rsh" >> /etc/securetty
                                  echo "${IPADDR} hinemos" > ~/.rhosts
			  
		          #性能管理機能のセットアップ
				  echo "性能管理機能のセットアップを行なっています。"
				  echo "Net-SNMPのインストール"
				  rpm -Uvh --force --nosignature $SNMP_RPM
				  echo "view    systemview    included   .1.3.6.1" >> /etc/snmp/snmpd.conf 
				  echo "/etc/init.d/snmpd restart"
				  /etc/init.d/snmpd restart
				  echo "/sbin/chkconfig --level 345 snmpd on"
				  /sbin/chkconfig --level 345 snmpd on
			  
          		  #状態監視機能のセットアップ
				  echo "状態監視機能のセットアップを行なっています。"
				  echo "syslog-ngのインストール"
				  rpm -Uvh --force $SYSLOG_NG_RPM
				  echo "#add for Hinemos" >> /etc/syslog-ng/syslog-ng.conf
				  echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> /etc/syslog-ng/syslog-ng.conf
				  echo "log { source(s_local);filter(f_messages);destination(d_hinemos);};" >> /etc/syslog-ng/syslog-ng.conf
				  /etc/init.d/syslog stop
				  /etc/init.d/syslog-ng start
				  /sbin/chkconfig --level 2345 syslog off
				  /sbin/chkconfig --level 2345 syslog-ng on
				  echo ""

		      break
		      ;;

		      n|N)
			  echo "インストールを中止してメニューに戻ります。"
			  echo ""
			  sleep 1
			  break
			  ;;
		      *)
		  esac
		done
                ;;
      2)      
	  echo "Hinemosエージェントをアンインストールします。よろしいですか?(Y/N)"
	  read ANS
	  case ${ANS} in
	      y|Y)
		  /etc/init.d/syslog-ng stop
		  rpm -e syslog-ng libol
		  rm -fr /etc/syslog-ng/
		  /etc/init.d/syslog start
		  /sbin/chkconfig --level 2345 syslog on
		  /etc/init.d/snmpd stop
		  /sbin/chkconfig --level 2345 snmpd off
		  rm -fr ${HINEMOS_AGENT_HOME}/lib/agent
		  rm -fr ${HINEMOS_AGENT_HOME}/bin/agent*
		  sed "/rsh/d" /etc/securetty > /etc/securetty_tmp
		  mv /etc/securetty_tmp /etc/securetty 
		  sed "/hinemos/d" ~/.rhosts > ~/.rhosts_tmp
		  mv ~/.rhosts_tmp ~/.rhosts 
		  if [ -f ~/.bash_profile.org ]; then
		      echo "mv -f ~/.bash_profile.org ~/.bash_profile"
		      mv -f ~/.bash_profile.org ~/.bash_profile
		  else
		      echo "cp -f /etc/skel/.bash_profile ~/.bash_profile"
		      cp -f /etc/skel/.bash_profile ~/.bash_profile
		  fi
		  ;;
	      *)
		  ;;
	  esac
	  echo ""
	  ;;
      9)      
	  echo "Hinemos インストーラを終了します。"
	  exit
	  ;;
	*)
	  echo ""
	  sleep 1
	  ;;
  esac
done
