/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.NotFoundInDispatcherException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.proxy.Proxy;

public class Dispatcher {
    public static final String DISPATCHER = "DISPATCHER";
    public static final String OID = "OID";
    public static final Dispatcher singleton = new Dispatcher();
    Object maplock = new Object();
    HashMap targetMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(Object oid) {
        Object object = this.maplock;
        synchronized (object) {
            return this.targetMap.containsKey(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTarget(Object oid, Object target) {
        Object object = this.maplock;
        synchronized (object) {
            this.targetMap.put(oid, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTarget(Object oid) {
        Object object = this.maplock;
        synchronized (object) {
            this.targetMap.remove(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRegistered(Object oid) {
        Object object = this.maplock;
        synchronized (object) {
            return this.targetMap.get(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse invoke(Invocation invocation) throws NotFoundInDispatcherException, Throwable {
        Advisor advisor;
        ClassProxy proxy;
        Object oid = invocation.getMetaData(DISPATCHER, OID);
        Object target = null;
        Object object = this.maplock;
        synchronized (object) {
            target = this.targetMap.get(oid);
        }
        if (target == null) {
            throw new NotFoundInDispatcherException(oid);
        }
        if (target instanceof ClassProxy) {
            proxy = (ClassProxy)target;
            return proxy._dynamicInvoke(invocation);
        }
        if (target instanceof Proxy) {
            proxy = (ClassProxy)target;
            return proxy._dynamicInvoke(invocation);
        }
        if (target instanceof Advised) {
            advisor = ((Advised)target)._getAdvisor();
            return advisor.dynamicInvoke(target, invocation);
        }
        if (target instanceof Advisor) {
            advisor = (Advisor)target;
            return advisor.dynamicInvoke(null, invocation);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long methodHash = methodInvocation.getMethodHash();
            HashMap methodMap = ClassProxyFactory.getMethodMap(target.getClass());
            Method method = (Method)methodMap.get(new Long(methodHash));
            Object[] args = methodInvocation.getArguments();
            try {
                return new InvocationResponse(method.invoke(target, args));
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        throw new RuntimeException("field invocations not implemented");
    }
}

