/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view.action;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import javax.ejb.RemoveException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DeleteCollectedDataAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.DeleteCollectedDataAction";
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        CurrentListView listView = (CurrentListView)page.findView(Messages.getString("VIEW_CURRENT_LIST"));
        if (listView.getSelectedID() != null) {
            if (!RecordController.getInstance().checkPermissionWrite()) {
                MessageDialog.openInformation(null, (String)com.clustercontrol.util.Messages.getString((String)"message"), (String)com.clustercontrol.util.Messages.getString((String)"message.accesscontrol.16"));
                return;
            }
            String msg = String.valueOf(Messages.getString("MESSAGE_0028")) + " " + listView.getSelectedID() + Messages.getString("MESSAGE_0016");
            if (MessageDialog.openQuestion(null, (String)Messages.getString("MESSAGE_0020"), (String)msg)) {
                RecordController controller = RecordController.getInstance();
                if (controller == null) {
                    MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
                    return;
                }
                try {
                    RecordController.getInstance().unlock();
                    if (!controller.deleteRecordCollector(listView.getSelectedID())) {
                        MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("DELETE_DATA_ERROR_MESSAGE"));
                    }
                }
                catch (RemoveException removeException) {
                    MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("DELETE_DATA_LOCKED_MESSAGE"));
                }
                listView.refresh();
            }
        } else {
            String msg = Messages.getString("MESSAGE_0014");
            MessageDialog.openError(null, (String)Messages.getString("ERROR_IN_JP"), (String)msg);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

