/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view.action;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.dialog.RecordSetDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import javax.ejb.DuplicateKeyException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SetCollectorAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.SetCollectorAction";
    private static RecordSetDialog setDialog;
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        if (!(RecordController.getInstance().checkPermissionRead() && RecordController.getInstance().checkPermissionWrite() && RecordController.getInstance().checkPermissionExecute())) {
            MessageDialog.openInformation(null, (String)com.clustercontrol.util.Messages.getString((String)"message"), (String)com.clustercontrol.util.Messages.getString((String)"message.accesscontrol.16"));
            return;
        }
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }
        Shell shell = new Shell();
        setDialog = new RecordSetDialog(shell);
        int ret = setDialog.open();
        if (ret == 0) {
            CollectorProperty property = setDialog.getInputData();
            try {
                if (!controller.registRecordCollector(property)) {
                    MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("START_COLLECTOR_ERROR_MESSAGE"));
                }
            }
            catch (DuplicateKeyException duplicateKeyException) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("START_COLLECTOR_DUPLICATEKEY_MESSAGE"));
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            CurrentListView currentListView = (CurrentListView)page.findView(Messages.getString("VIEW_CURRENT_LIST"));
            currentListView.refresh();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

