/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.NonDisposingHandle;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.components.registry.ComponentRegistry;
import org.eclipse.ui.internal.components.registry.ComponentTypeMap;
import org.eclipse.ui.internal.components.registry.IComponentScope;
import org.eclipse.ui.internal.components.registry.IScopeReference;
import org.eclipse.ui.internal.components.registry.ScopeDefinition;
import org.eclipse.ui.internal.components.registry.ScopeReference;
import org.eclipse.ui.internal.components.registry.SymbolicScopeReference;

public class ComponentScope
extends ServiceFactory
implements IComponentScope {
    private String scopeId;
    private ComponentTypeMap types = new ComponentTypeMap();
    private ComponentTypeMap modifiers = new ComponentTypeMap();
    private IScopeReference[] parentScopes = new IScopeReference[0];
    private ClassIdentifier[] dependencies = new ClassIdentifier[0];
    private static final String impossibleToSatisfyDependency = "Dependency that is impossible to satisfy";
    private boolean loaded = false;
    private ArrayList children = new ArrayList();
    private ServiceFactory[] parentContexts = new ServiceFactory[0];
    private ArrayList scopeDependencies = new ArrayList();

    public ComponentScope(String scopeId) {
        this.scopeId = scopeId;
    }

    public IServiceProvider getContainer(ServiceFactory context) {
        return null;
    }

    public ComponentHandle createHandle(Object key, IServiceProvider container) throws ComponentException {
        ComponentFactory factory;
        if (key == this) {
            return new NonDisposingHandle(this);
        }
        if (key instanceof Class && (factory = (ComponentFactory)this.types.get((Class)key)) != null) {
            return factory.createHandle(container);
        }
        int i = 0;
        while (i < this.parentContexts.length) {
            ServiceFactory context = this.parentContexts[i];
            ComponentHandle handle = context.createHandle(key, container);
            if (handle != null) {
                return handle;
            }
            ++i;
        }
        return null;
    }

    public boolean hasService(Object componentKey) {
        return this.hasKey(componentKey, null);
    }

    private boolean hasKey(Object key, ServiceFactory parentScopeToSkip) {
        if (key == this) {
            return true;
        }
        if (key instanceof Class && this.types.containsKey((Class)key)) {
            return true;
        }
        int i = 0;
        while (i < this.parentContexts.length) {
            ServiceFactory context = this.parentContexts[i];
            if (context != parentScopeToSkip && context.hasService(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ComponentFactory lookup(ClassIdentifier type) {
        return (ComponentFactory)this.types.get(type);
    }

    public void put(ClassIdentifier type, ComponentFactory factory) {
        this.types.put(type, factory);
    }

    public void remove(ClassIdentifier type) {
        this.types.remove(type);
    }

    public ClassIdentifier[] getTypes() {
        return this.types.getTypes();
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public IScopeReference[] getParentScopes() {
        return this.parentScopes;
    }

    public ClassIdentifier[] getDependencies() {
        return this.dependencies;
    }

    public ServiceFactory getContext() {
        return this;
    }

    public Collection getMissingDependencies() {
        if (!this.loaded) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(impossibleToSatisfyDependency);
            return result;
        }
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < this.dependencies.length) {
            ClassIdentifier type = this.dependencies[i];
            try {
                Class dep = ComponentUtil.loadClass(type);
                if (this.types.get(dep) == null) {
                    result.add(dep);
                }
            }
            catch (ComponentException e) {
                WorkbenchPlugin.log(e);
                result.add(impossibleToSatisfyDependency);
            }
            ++i;
        }
        i = 0;
        while (i < this.parentScopes.length) {
            ServiceFactory context;
            IScopeReference ref = this.parentScopes[i];
            if (ref.getRelationship() == 0 && !this.hasService(context = ((ComponentScope)ref.getTarget()).getContext())) {
                result.add(context);
            }
            ++i;
        }
        i = 0;
        while (i < this.parentContexts.length) {
            ServiceFactory next = this.parentContexts[i];
            Collection parentMissing = next.getMissingDependencies();
            Iterator iter = parentMissing.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (this.hasKey(object, next)) continue;
                result.add(object);
            }
            ++i;
        }
        return result;
    }

    public void load(ScopeDefinition def, ComponentRegistry reg) {
        if (this.loaded) {
            this.unload(reg);
        }
        this.dependencies = def.getDependencies();
        SymbolicScopeReference[] refs = def.getExtends();
        IScopeReference[] parents = new IScopeReference[refs.length];
        ArrayList<ServiceFactory> parentContextList = new ArrayList<ServiceFactory>();
        int i = 0;
        while (i < refs.length) {
            SymbolicScopeReference reference = refs[i];
            ScopeReference ref = new ScopeReference(reference.relationship, reg.linkSubScope(reference.scopeId, this, reference.relationship));
            parents[i] = ref;
            if (reference.relationship == 0) {
                this.scopeDependencies.add(((ComponentScope)ref.getTarget()).getContext());
            } else {
                parentContextList.add(((ComponentScope)ref.getTarget()).getContext());
            }
            ++i;
        }
        this.parentContexts = parentContextList.toArray(new ServiceFactory[parentContextList.size()]);
        this.parentScopes = parents;
        this.loaded = true;
    }

    public void unload(ComponentRegistry reg) {
        int i = 0;
        while (i < this.parentScopes.length) {
            IScopeReference ref = this.parentScopes[i];
            reg.unlinkSubScope(ref.getTarget().getScopeId(), this);
            ++i;
        }
        this.scopeDependencies = new ArrayList();
        this.parentScopes = new IScopeReference[0];
        this.dependencies = new ClassIdentifier[0];
        this.parentContexts = new ServiceFactory[0];
        this.loaded = false;
    }

    public boolean isRedundant() {
        return !this.loaded && this.getChildScopes().length == 0 && this.types.isEmpty() && this.modifiers.isEmpty();
    }

    public void addChild(ComponentScope child, int relationship) {
        this.children.add(new ScopeReference(relationship, child));
    }

    public void removeChild(ComponentScope child) {
        IScopeReference[] refs = this.children.toArray(new IScopeReference[this.children.size()]);
        int i = 0;
        while (i < refs.length) {
            IScopeReference reference = refs[i];
            if (reference.getTarget() == child) {
                this.children.remove(reference);
            }
            ++i;
        }
    }

    public String toString() {
        return "scope " + this.scopeId;
    }

    public IScopeReference[] getChildScopes() {
        return this.children.toArray(new IScopeReference[this.children.size()]);
    }
}

