/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performanceMGR.bean.RawValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordDataDAO {
    protected static Log m_log = LogFactory.getLog(RecordDataDAO.class);

    public List selectRecordData(String collectorID, String OID, String facilityID, Date startDate, Date stopDate) throws EJBException {
        m_log.debug((Object)("selectRecordData() start :" + collectorID + " " + OID));
        ArrayList<RawValue> ret = new ArrayList<RawValue>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        boolean checkAllNull = true;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT V1.DATE_TIME, V2.VALUE FROM ( SELECT DATE_TIME FROM PERFORMANCE_DATA WHERE COLLECTORID=? AND OBJECTID='.1.3.6.1.2.1.25.1.1.0' AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ? ) AS V1 LEFT OUTER JOIN  (SELECT DATE_TIME ,VALUE FROM PERFORMANCE_DATA WHERE COLLECTORID=? AND OBJECTID=? AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ? ) AS V2 USING (DATE_TIME)";
            stmt = conn.prepareStatement(sql);
            Timestamp start = new Timestamp(startDate.getTime());
            Timestamp stop = new Timestamp(stopDate.getTime());
            stmt.setString(1, collectorID);
            stmt.setString(2, facilityID);
            stmt.setTimestamp(3, start);
            stmt.setTimestamp(4, stop);
            stmt.setString(5, collectorID);
            stmt.setString(6, OID);
            stmt.setString(7, facilityID);
            stmt.setTimestamp(8, start);
            stmt.setTimestamp(9, stop);
            res = stmt.executeQuery();
            long value = 0L;
            while (res.next()) {
                if (res.getString("VALUE") != null) {
                    checkAllNull = false;
                    value = res.getLong("VALUE");
                } else {
                    value = 0L;
                }
                RawValue rv = new RawValue(new Date(res.getTimestamp("DATE_TIME").getTime()), value);
                ret.add(rv);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectRecordData() error :" + facilityID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectRecordData() error :" + facilityID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectRecordData() end :" + collectorID + " " + OID));
        if (checkAllNull) {
            return new ArrayList();
        }
        return ret;
    }

    public Hashtable selectRecordData10(String collectorID, HashSet tmpSet, String facilityID, Date startDate, Date stopDate) throws EJBException {
        m_log.debug((Object)("selectRecordData() start :" + collectorID));
        Hashtable ret = new Hashtable();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            Timestamp start = new Timestamp(startDate.getTime());
            Timestamp stop = new Timestamp(stopDate.getTime());
            Iterator it = null;
            String sql = "SELECT VV0.DATE_TIME, VV0.VALUE";
            for (int i = 0; i < tmpSet.size(); ++i) {
                sql = sql + ", " + "V" + i + ".VALUE";
            }
            sql = sql + " FROM ( SELECT DATE_TIME , VALUE FROM PERFORMANCE_DATA " + "WHERE COLLECTORID='" + collectorID + "'" + " AND OBJECTID='.1.3.6.1.2.1.25.1.1.0'" + " AND FACILITYID='" + facilityID + "'" + " AND DATE_TIME BETWEEN '" + start.toString() + "'" + " AND '" + stop.toString() + "'" + ") AS VV0 ";
            ArrayList al1 = new ArrayList();
            ret.put("datetime", al1);
            int i = 0;
            for (String oid : tmpSet) {
                sql = sql + " LEFT OUTER JOIN  " + "(SELECT DATE_TIME , VALUE FROM PERFORMANCE_DATA " + "WHERE COLLECTORID='" + collectorID + "'" + " AND OBJECTID='" + oid + "'" + " AND FACILITYID='" + facilityID + "'" + " AND DATE_TIME BETWEEN '" + start.toString() + "'" + " AND '" + stop.toString() + "'" + ") AS V" + i + " USING (DATE_TIME)";
                ArrayList al = new ArrayList();
                ret.put(oid, al);
                ++i;
            }
            sql = sql + " ORDER BY DATE_TIME";
            stmt = conn.createStatement();
            ResultSet res = stmt.executeQuery(sql);
            while (res.next()) {
                ((ArrayList)ret.get("datetime")).add(new Date(res.getTimestamp("DATE_TIME").getTime()));
                int j = 0;
                it = tmpSet.iterator();
                while (it.hasNext()) {
                    ((ArrayList)ret.get((String)it.next())).add(new Long(res.getLong(j + 3)));
                    ++j;
                }
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectRecordData() error :" + facilityID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectRecordData() error :" + facilityID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectRecordData() end :" + collectorID));
        return ret;
    }

    public void deleteRecordData(String collectorID) throws EJBException {
        m_log.debug((Object)("deleteRecordData() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM PERFORMANCE_DATA WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("deleteRecordData() error :" + collectorID + " EJBException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteRecordData() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteRecordData() end :" + collectorID));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRecordData(String collectorID, String OID, Date date, String facilityID, long value) throws EJBException {
        m_log.debug((Object)("insertRecordData() start :" + collectorID + " " + OID + " " + date.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        Timestamp time = new Timestamp(date.getTime());
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO PERFORMANCE_DATA (collectorID, ObjectID,date_time,facilityid,value)values (?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setString(2, OID);
                stmt.setTimestamp(3, time);
                stmt.setString(4, facilityID);
                stmt.setLong(5, value);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.error((Object)("insertRecordData() error :" + collectorID + " EJBException "));
                throw new EJBException(e.getMessage());
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insertRecordData() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insertRecordData() end :" + collectorID + " " + OID + " " + date.toString()));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("insertRecordData() error :" + collectorID + " EJBException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("insertRecordData() end :" + collectorID + " " + OID + " " + date.toString()));
    }

    public ArrayList selectObjectID(String collectorID, String facilityID, String oid) {
        return null;
    }
}

