/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class BaseTreeItemSelectionListener
implements SelectionListener {
    protected TreeComposite composite;

    public BaseTreeItemSelectionListener(TreeComposite composite) {
        this.composite = composite;
    }

    public void widgetSelected(SelectionEvent event) {
    }

    protected boolean checkCreateItem() {
        if (this.composite.getCreateItem() != null) {
            TreeItem createItem = this.composite.getCreateItem();
            TreeItem parent = createItem.getParent();
            Object[] args = new Object[]{createItem.getInfo().getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.8", (Object[])args))) {
                parent.removeChildren(createItem);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)parent);
            }
            return false;
        }
        return true;
    }

    protected boolean checkUpdateItem() {
        TreeItem selectItem = this.composite.getSelectItem();
        if (this.composite.getUpdateItem() != null) {
            TreeItem updateItem = this.composite.getUpdateItem();
            Object[] args = new Object[]{updateItem.getInfo().getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.9", (Object[])args))) {
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)selectItem), true);
            }
            return false;
        }
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

