/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AttributeDispatcher;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.ReflectedDispatcher;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationContext;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.MethodMapper;
import org.jboss.mx.server.TCLAction;
import org.jboss.mx.server.TimeoutException;
import org.jboss.mx.server.registry.MBeanEntry;

public abstract class AbstractMBeanInvoker
implements MBeanInvoker {
    static ThreadLocal preRegisterInfo = new ThreadLocal();
    private Object resource = null;
    protected MBeanEntry resourceEntry = null;
    protected boolean dynamicResource = true;
    protected MBeanInfo info = null;
    protected Map attributeContextMap = new HashMap();
    protected Map operationContextMap = new HashMap();
    protected Map constructorContextMap = new HashMap();
    protected InvocationContext getMBeanInfoCtx = null;
    protected InvocationContext preRegisterCtx = null;
    protected InvocationContext postRegisterCtx = null;
    protected InvocationContext preDeregisterCtx = null;
    protected InvocationContext postDeregisterCtx = null;
    protected Logger log = Logger.getLogger(class$org$jboss$mx$server$AbstractMBeanInvoker == null ? (class$org$jboss$mx$server$AbstractMBeanInvoker = AbstractMBeanInvoker.class$("org.jboss.mx.server.AbstractMBeanInvoker")) : class$org$jboss$mx$server$AbstractMBeanInvoker);
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$mx$server$AbstractMBeanInvoker;
    static /* synthetic */ Class class$javax$management$MBeanServer;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static void setMBeanEntry(MBeanEntry entry) {
        preRegisterInfo.set(entry);
    }

    public static MBeanEntry getMBeanEntry() {
        return (MBeanEntry)preRegisterInfo.get();
    }

    public AbstractMBeanInvoker() {
    }

    public AbstractMBeanInvoker(Object resource) {
        this.resource = resource;
    }

    public AbstractMBeanInvoker(MBeanEntry resourceEntry) {
        this.resourceEntry = resourceEntry;
        this.resource = resourceEntry.getResourceInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(String operationName, Object[] args, String[] signature) throws MBeanException, ReflectionException {
        Object object;
        boolean setCl;
        OperationKey key;
        InvocationContext ctx;
        int dot;
        if (operationName == null) {
            throw new ReflectionException(new IllegalArgumentException("Null operation name"));
        }
        String opName = operationName;
        if (this.dynamicResource && (dot = operationName.lastIndexOf(46)) != -1 && dot < operationName.length() - 1) {
            opName = operationName.substring(dot + 1);
        }
        if ((ctx = (InvocationContext)this.operationContextMap.get(key = new OperationKey(opName, signature))) == null) {
            boolean operationExists = false;
            if (!this.dynamicResource) throw new ReflectionException(new IllegalArgumentException("Unable to find operation " + operationName + this.getSignatureString(signature)));
            Iterator i = this.operationContextMap.keySet().iterator();
            while (i.hasNext()) {
                OperationKey thisKey = (OperationKey)i.next();
                if (!opName.equals(thisKey.keys[0])) continue;
                operationExists = true;
                break;
            }
            if (!operationExists) throw new ReflectionException(new IllegalArgumentException("Unable to find operation " + operationName + this.getSignatureString(signature)));
            throw new ReflectionException(new NoSuchMethodException("Unable to find operation " + operationName + this.getSignatureString(signature)));
        }
        Invocation invocation = new Invocation();
        invocation.addContext(ctx);
        invocation.setType("invoke");
        invocation.setName(operationName);
        invocation.setArgs(args);
        this.override(invocation);
        ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
        ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = ccl != mbeanTCL && mbeanTCL != null;
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(mbeanTCL);
        }
        try {
            try {
                object = invocation.invoke();
                Object var14_20 = null;
            }
            catch (MBeanException e) {
                throw e;
            }
            catch (ReflectionException e) {
                throw e;
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                this.rethrowAsMBeanException(t);
                Object var12_29 = null;
                Object var14_21 = null;
                Descriptor descriptor = invocation.getDescriptor();
                if (descriptor != null) {
                    ctx.setDescriptor(descriptor);
                    if (this.dynamicResource && "operation".equals(descriptor.getFieldValue("descriptorType"))) {
                        ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
                        minfo.setDescriptor(descriptor, "operation");
                    }
                }
                invocation.setArgs(null);
                invocation.setDescriptor(null);
                invocation.setDispatcher(null);
                if (!setCl) return var12_29;
                TCLAction.UTIL.setContextClassLoader(ccl);
                return var12_29;
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            Descriptor descriptor = invocation.getDescriptor();
            if (descriptor != null) {
                ctx.setDescriptor(descriptor);
                if (this.dynamicResource && "operation".equals(descriptor.getFieldValue("descriptorType"))) {
                    ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
                    minfo.setDescriptor(descriptor, "operation");
                }
            }
            invocation.setArgs(null);
            invocation.setDescriptor(null);
            invocation.setDispatcher(null);
            if (!setCl) throw throwable;
            TCLAction.UTIL.setContextClassLoader(ccl);
            throw throwable;
        }
        Descriptor descriptor = invocation.getDescriptor();
        if (descriptor != null) {
            ctx.setDescriptor(descriptor);
            if (this.dynamicResource && "operation".equals(descriptor.getFieldValue("descriptorType"))) {
                ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
                minfo.setDescriptor(descriptor, "operation");
            }
        }
        invocation.setArgs(null);
        invocation.setDescriptor(null);
        invocation.setDispatcher(null);
        if (!setCl) return object;
        TCLAction.UTIL.setContextClassLoader(ccl);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object;
        boolean setCl;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot get null attribute"));
        }
        InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(attribute);
        if (ctx == null) {
            throw new AttributeNotFoundException("not found: " + attribute);
        }
        if (!ctx.isReadable()) {
            throw new AttributeNotFoundException("Attribute '" + attribute + "' found, but it is not readable");
        }
        Invocation invocation = new Invocation();
        invocation.addContext(ctx);
        invocation.setType("getAttribute");
        invocation.setArgs(null);
        this.override(invocation);
        ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
        ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = ccl != mbeanTCL && mbeanTCL != null;
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(mbeanTCL);
        }
        try {
            try {
                object = invocation.invoke();
                Object var10_13 = null;
            }
            catch (AttributeNotFoundException e) {
                throw e;
            }
            catch (MBeanException e) {
                throw e;
            }
            catch (ReflectionException e) {
                throw e;
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                this.rethrowAsMBeanException(t);
                Object var8_19 = null;
                Object var10_14 = null;
                Descriptor attrDesc = invocation.getDescriptor();
                ctx.setDescriptor(attrDesc);
                this.updateAttributeInfo(attrDesc);
                if (!setCl) return var8_19;
                TCLAction.UTIL.setContextClassLoader(ccl);
                return var8_19;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            Descriptor attrDesc = invocation.getDescriptor();
            ctx.setDescriptor(attrDesc);
            this.updateAttributeInfo(attrDesc);
            if (!setCl) throw throwable;
            TCLAction.UTIL.setContextClassLoader(ccl);
            throw throwable;
        }
        Descriptor attrDesc = invocation.getDescriptor();
        ctx.setDescriptor(attrDesc);
        this.updateAttributeInfo(attrDesc);
        if (!setCl) return object;
        TCLAction.UTIL.setContextClassLoader(ccl);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        boolean setCl;
        if (attribute == null) {
            throw new InvalidAttributeValueException("null attribute");
        }
        String name = attribute.getName();
        InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
        if (ctx == null) {
            throw new AttributeNotFoundException("not found: " + name);
        }
        if (!ctx.isWritable()) {
            throw new AttributeNotFoundException("Attribute '" + name + "' is not writable");
        }
        Invocation invocation = new Invocation();
        invocation.addContext(ctx);
        invocation.setType("setAttribute");
        invocation.setArgs(new Object[]{attribute.getValue()});
        this.override(invocation);
        ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
        ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = ccl != mbeanTCL && mbeanTCL != null;
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(mbeanTCL);
        }
        try {
            try {
                invocation.invoke();
            }
            catch (AttributeNotFoundException e) {
                throw e;
            }
            catch (InvalidAttributeValueException e) {
                throw e;
            }
            catch (MBeanException e) {
                throw e;
            }
            catch (ReflectionException e) {
                throw e;
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                this.rethrowAsMBeanException(t);
                Object var10_9 = null;
                Descriptor attrDesc = invocation.getDescriptor();
                ctx.setDescriptor(attrDesc);
                this.updateAttributeInfo(attrDesc);
                if (!setCl) return;
                TCLAction.UTIL.setContextClassLoader(ccl);
                return;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Descriptor attrDesc = invocation.getDescriptor();
            ctx.setDescriptor(attrDesc);
            this.updateAttributeInfo(attrDesc);
            if (!setCl) throw throwable;
            TCLAction.UTIL.setContextClassLoader(ccl);
            throw throwable;
        }
        Descriptor attrDesc = invocation.getDescriptor();
        ctx.setDescriptor(attrDesc);
        this.updateAttributeInfo(attrDesc);
        if (!setCl) return;
        TCLAction.UTIL.setContextClassLoader(ccl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() {
        boolean setCl;
        Invocation invocation = new Invocation(this.getMBeanInfoCtx);
        invocation.setType("getMBeanInfo");
        if (this.resourceEntry == null) {
            this.resourceEntry = AbstractMBeanInvoker.getMBeanEntry();
        }
        ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
        ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = ccl != mbeanTCL && mbeanTCL != null;
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(mbeanTCL);
        }
        try {
            MBeanInfo info;
            MBeanInfo mBeanInfo = info = (MBeanInfo)invocation.invoke();
            return mBeanInfo;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            this.rethrowAsRuntimeMBeanException(t);
            MBeanInfo mBeanInfo = null;
            return mBeanInfo;
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(ccl);
            }
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("null array");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("null list");
        }
        AttributeList results = new AttributeList();
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            try {
                this.setAttribute(attr);
                results.add(attr);
            }
            catch (Throwable ignored) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Unhandled setAttribute() for attribute: " + attr.getName(), ignored);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        boolean setCl;
        this.resourceEntry = (MBeanEntry)preRegisterInfo.get();
        this.server = server;
        ObjectName mbeanName = null;
        Descriptor mbeanDescriptor = null;
        if (this.info instanceof ModelMBeanInfo) {
            ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)this.info);
            try {
                mbeanDescriptor = minfo.getDescriptor("", "mbean");
                String type = (String)mbeanDescriptor.getFieldValue("MBeanServerType");
                if (type != null) {
                    this.inject("MBeanServerType", type, class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = AbstractMBeanInvoker.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer, this.getServer());
                }
            }
            catch (MBeanException e) {
                this.log.warn("Failed to obtain descriptor: mbean", e);
            }
        }
        ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
        ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = ccl != mbeanTCL && mbeanTCL != null;
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(mbeanTCL);
        }
        try {
            Object value;
            String type;
            this.initAttributeContexts(this.info.getAttributes());
            this.initOperationContexts(this.info.getOperations());
            if (this.resource != null) {
                this.initDispatchers();
            }
            mbeanName = this.invokePreRegister(server, name);
            if (mbeanDescriptor != null && (type = (String)(value = mbeanDescriptor.getFieldValue("ObjectNameType"))) != null) {
                this.inject("ObjectNameType", type, class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = AbstractMBeanInvoker.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, mbeanName);
            }
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(ccl);
            }
        }
        return mbeanName;
    }

    public void postRegister(Boolean registrationSuccessful) {
        this.invokePostRegister(registrationSuccessful);
    }

    public void preDeregister() throws Exception {
        this.invokePreDeregister();
    }

    public void postDeregister() {
        this.invokePostDeregister();
        this.server = null;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.addNotificationListenerToResource(listener, filter, handback);
    }

    protected void addNotificationListenerToResource(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (!(this.resource instanceof NotificationBroadcaster)) {
            throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification broadcaster"));
        }
        ((NotificationBroadcaster)this.resource).addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.removeNotificationListenerFromResource(listener);
    }

    protected void removeNotificationListenerFromResource(NotificationListener listener) throws ListenerNotFoundException {
        if (!(this.resource instanceof NotificationBroadcaster)) {
            throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification broadcaster"));
        }
        ((NotificationBroadcaster)this.resource).removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListenerFromResource(listener, filter, handback);
    }

    protected void removeNotificationListenerFromResource(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.resource instanceof NotificationEmitter) {
            ((NotificationEmitter)this.resource).removeNotificationListener(listener, filter, handback);
        } else if (this.resource instanceof NotificationBroadcaster) {
            this.removeNotificationListener(listener);
        } else {
            throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification emitter"));
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getNotificationInfoFromResource();
    }

    protected MBeanNotificationInfo[] getNotificationInfoFromResource() {
        if (this.resource instanceof NotificationBroadcaster) {
            return ((NotificationBroadcaster)this.resource).getNotificationInfo();
        }
        return new MBeanNotificationInfo[0];
    }

    public MBeanInfo getMetaData() {
        return this.info;
    }

    public Object getResource() {
        return this.resource;
    }

    public void setResource(Object resource) {
        this.resource = resource;
    }

    public ObjectName getObjectName() {
        if (this.resourceEntry == null) {
            return null;
        }
        return this.resourceEntry.getObjectName();
    }

    public void updateAttributeInfo(Descriptor attrDesc) throws MBeanException {
        ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
        minfo.setDescriptor(attrDesc, "attribute");
    }

    public void addOperationInterceptor(Interceptor interceptor) {
        if (this.operationContextMap != null && interceptor != null) {
            Iterator it = this.operationContextMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                InvocationContext ctx = (InvocationContext)entry.getValue();
                List list = ctx.getInterceptors();
                ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
                newList.add(interceptor);
                if (list != null) {
                    newList.addAll(list);
                }
                ctx.setInterceptors(newList);
            }
        }
    }

    public void removeOperationInterceptor(Interceptor interceptor) {
        if (this.operationContextMap != null && interceptor != null) {
            Iterator it = this.operationContextMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                InvocationContext ctx = (InvocationContext)entry.getValue();
                List list = ctx.getInterceptors();
                if (list == null) continue;
                ArrayList newList = new ArrayList(list);
                newList.remove(interceptor);
                ctx.setInterceptors(newList);
            }
        }
    }

    public void suspend() {
    }

    public void suspend(long wait) throws TimeoutException {
    }

    public void suspend(boolean force) {
    }

    public boolean isSuspended() {
        return false;
    }

    public void setInvocationTimeout(long time) {
    }

    public long getInvocationTimeout() {
        return 0L;
    }

    public void resume() {
    }

    public MBeanServer getServer() {
        return this.server;
    }

    protected void inject(String type, String name, Class argType, Object value) {
        try {
            Class<?> resClass = this.resource.getClass();
            Class[] sig = new Class[]{argType};
            Method setter = resClass.getMethod(name, sig);
            Object[] args = new Object[]{value};
            setter.invoke(this.resource, args);
        }
        catch (NoSuchMethodException e) {
            this.log.debug("Setter not found: " + name + "(" + argType + ")", e);
        }
        catch (Exception e) {
            this.log.warn("Failed to inject type: " + type + " using setter: " + name, e);
        }
    }

    protected ObjectName invokePreRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            return ((MBeanRegistration)this.resource).preRegister(server, name);
        }
        return name;
    }

    protected void invokePostRegister(Boolean b) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(b);
        }
    }

    protected void invokePreDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    protected void invokePostDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }

    protected void initAttributeContexts(MBeanAttributeInfo[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            InvocationContext ctx = new InvocationContext();
            ctx.setName(attributes[i].getName());
            ctx.setAttributeType(attributes[i].getType());
            ctx.setInvoker(this);
            this.attributeContextMap.put(attributes[i].getName(), ctx);
        }
    }

    protected void initOperationContexts(MBeanOperationInfo[] operations) {
        for (int i = 0; i < operations.length; ++i) {
            InvocationContext ctx = new InvocationContext();
            String opName = operations[i].getName();
            MBeanParameterInfo[] signature = operations[i].getSignature();
            String returnType = operations[i].getReturnType();
            ctx.setName(opName);
            ctx.setSignature(signature);
            ctx.setReturnType(returnType);
            ctx.setInvoker(this);
            OperationKey opKey = new OperationKey(opName, signature);
            this.operationContextMap.put(opKey, ctx);
        }
    }

    protected void initDispatchers() {
        MBeanOperationInfo[] operations = this.info.getOperations();
        Class<?> clazz = this.resource == null ? null : this.resource.getClass();
        MethodMapper mmap = new MethodMapper(clazz);
        for (int i = 0; i < operations.length; ++i) {
            MBeanOperationInfo op = operations[i];
            OperationKey opKey = new OperationKey(op.getName(), op.getSignature());
            InvocationContext ctx = (InvocationContext)this.operationContextMap.get(opKey);
            Interceptor dispatcher = ctx.getDispatcher();
            if (!(dispatcher instanceof InvocationContext.NullDispatcher) && !(dispatcher instanceof ReflectedDispatcher)) continue;
            Object target = null;
            dispatcher = null;
            Method m = mmap.lookupOperation(op);
            if (m == null) {
                m = mmap.lookupOperation(op, this);
                if (m != null) {
                    target = this;
                    dispatcher = new ReflectedDispatcher(m, this.dynamicResource);
                } else {
                    dispatcher = new ReflectedDispatcher(this.dynamicResource);
                }
            } else {
                target = this.resource;
                dispatcher = new ReflectedDispatcher(m, this.dynamicResource);
            }
            ctx.setTarget(target);
            ctx.setDispatcher(dispatcher);
        }
        MBeanAttributeInfo[] attributes = this.info.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attribute = attributes[i];
            String name = attribute.getName();
            InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
            Method getter = mmap.lookupGetter(attribute);
            Method setter = mmap.lookupSetter(attribute);
            ctx.setDispatcher(new AttributeDispatcher(getter, setter, this.dynamicResource));
            ctx.setTarget(this.resource);
        }
    }

    protected void override(Invocation invocation) throws MBeanException {
    }

    protected String getSignatureString(String[] signature) {
        if (signature == null) {
            return "()";
        }
        if (signature.length == 0) {
            return "()";
        }
        StringBuffer sbuf = new StringBuffer(512);
        sbuf.append("(");
        for (int i = 0; i < signature.length - 1; ++i) {
            sbuf.append(signature[i]);
            sbuf.append(",");
        }
        sbuf.append(signature[signature.length - 1]);
        sbuf.append(")");
        return sbuf.toString();
    }

    private void rethrowAsMBeanException(Throwable t) throws MBeanException {
        if (t instanceof RuntimeException) {
            throw new RuntimeMBeanException((RuntimeException)t);
        }
        if (t instanceof Error) {
            throw new RuntimeErrorException((Error)t);
        }
        throw new MBeanException((Exception)t);
    }

    private void rethrowAsRuntimeMBeanException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw new RuntimeMBeanException((RuntimeException)t);
        }
        if (t instanceof Error) {
            throw new RuntimeErrorException((Error)t);
        }
        throw new RuntimeMBeanException(new RuntimeException("Unhandled exception", t));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class OperationKey {
        String[] keys = null;
        int hash = 0;

        public OperationKey(String name, String type) {
            if (type != null) {
                this.keys = new String[2];
                this.keys[0] = name;
                this.keys[1] = type;
                this.hash = name.hashCode();
            } else {
                this.keys = new String[]{name};
                this.hash = name.hashCode();
            }
        }

        public OperationKey(String name, String[] signature) {
            if (signature != null) {
                this.keys = new String[signature.length + 1];
                this.keys[0] = name;
                System.arraycopy(signature, 0, this.keys, 1, signature.length);
                this.hash = name.hashCode();
            } else {
                this.keys = new String[]{name};
                this.hash = name.hashCode();
            }
        }

        public OperationKey(String name, MBeanParameterInfo[] signature) {
            if (signature == null) {
                signature = new MBeanParameterInfo[]{};
            }
            this.keys = new String[signature.length + 1];
            this.keys[0] = name;
            for (int i = 0; i < signature.length; ++i) {
                this.keys[i + 1] = signature[i].getType();
            }
            this.hash = name.hashCode();
        }

        public OperationKey(MBeanOperationInfo info) {
            this(info.getName(), info.getSignature());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            OperationKey target = (OperationKey)o;
            if (target.keys.length != this.keys.length) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i].equals(target.keys[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(this.keys[0]).append("(");
            for (int i = 1; i < this.keys.length - 1; ++i) {
                buffer.append(this.keys[i]);
            }
            if (this.keys.length > 1) {
                buffer.append(this.keys[this.keys.length - 1]);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

