/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.util.UnitType;

public class RectangleInsets
implements Serializable {
    private UnitType unitType;
    private double top;
    private double bottom;
    private double left;
    private double right;

    public RectangleInsets(UnitType unitType, double d, double d2, double d3, double d4) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        this.unitType = unitType;
        this.top = d;
        this.bottom = d2;
        this.left = d3;
        this.right = d4;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RectangleInsets) {
            RectangleInsets rectangleInsets = (RectangleInsets)object;
            if (rectangleInsets.unitType != this.unitType) {
                return false;
            }
            if (rectangleInsets.left != this.left) {
                return false;
            }
            if (rectangleInsets.right != this.right) {
                return false;
            }
            if (rectangleInsets.top != this.top) {
                return false;
            }
            return rectangleInsets.bottom == this.bottom;
        }
        return false;
    }

    public Rectangle2D createInsetRectangle(Rectangle2D rectangle2D) {
        return this.createInsetRectangle(rectangle2D, true, true);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl2) {
            d = this.calculateTopMargin(rectangle2D.getHeight());
            d2 = this.calculateBottomMargin(rectangle2D.getHeight());
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            d3 = this.calculateLeftMargin(rectangle2D.getWidth());
            d4 = this.calculateRightMargin(rectangle2D.getWidth());
        }
        return new Rectangle2D.Double(rectangle2D.getX() + d3, rectangle2D.getY() + d, rectangle2D.getWidth() - d3 - d4, rectangle2D.getHeight() - d - d2);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D rectangle2D) {
        return this.createOutsetRectangle(rectangle2D, true, true);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl2) {
            d = this.calculateTopMargin(rectangle2D.getHeight());
            d2 = this.calculateBottomMargin(rectangle2D.getHeight());
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            d3 = this.calculateLeftMargin(rectangle2D.getWidth());
            d4 = this.calculateRightMargin(rectangle2D.getWidth());
        }
        return new Rectangle2D.Double(rectangle2D.getX() - d3, rectangle2D.getY() - d, rectangle2D.getWidth() + d3 + d4, rectangle2D.getHeight() + d + d2);
    }

    public double calculateTopMargin(double d) {
        double d2 = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.top * d;
        }
        return d2;
    }

    public double calculateBottomMargin(double d) {
        double d2 = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.bottom * d;
        }
        return d2;
    }

    public double calculateLeftMargin(double d) {
        double d2 = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.left * d;
        }
        return d2;
    }

    public double calculateRightMargin(double d) {
        double d2 = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.right * d;
        }
        return d2;
    }
}

