/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemPK;
import com.clustercontrol.performanceMGR.bean.Facility;
import com.clustercontrol.performanceMGR.bean.Node;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import com.clustercontrol.performanceMGR.bean.Scope;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScopeTree
implements Serializable {
    protected static Log m_log = LogFactory.getLog(ScopeTree.class);
    private Hashtable m_scopeTable;
    private Hashtable m_nodeTable;
    private long m_lastCollectTime;
    private boolean updateFlag;

    public ScopeTree(FacilityTreeItem treeItem) {
        m_log.debug((Object)"ScopeTree \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf");
        this.m_scopeTable = new Hashtable();
        this.m_nodeTable = new Hashtable();
        this.setScopeTree(treeItem);
    }

    public void addScope(String facilityID, String facilityName, String parent) {
        Scope scope = new Scope(facilityID, facilityName);
        Scope parentScope = (Scope)this.m_scopeTable.get(parent);
        if (parentScope != null) {
            scope.addParents(parentScope);
            parentScope.addChildren(scope);
        }
        this.m_scopeTable.put(facilityID, scope);
    }

    public void addNode(String facilityID, String facilityName, String parent) {
        Scope parentScope;
        Node node = (Node)this.m_nodeTable.get(facilityID);
        if (node == null) {
            node = new Node(facilityID, facilityName);
        }
        if ((parentScope = (Scope)this.m_scopeTable.get(parent)) != null) {
            node.addParents(parentScope);
            parentScope.addChildren(node);
        }
        this.m_nodeTable.put(facilityID, node);
    }

    public boolean contains(String facilityID) {
        Scope scope = (Scope)this.m_scopeTable.get(facilityID);
        Node node = (Node)this.m_nodeTable.get(facilityID);
        return scope != null || node != null;
    }

    public String[] getNodeIDList(String facilityID) {
        Scope scope = (Scope)this.m_scopeTable.get(facilityID);
        String[] nodeListFaciliyID = null;
        HashSet nodeListSet = new HashSet();
        if (scope != null) {
            scope.getNode(nodeListSet);
            Node[] nodeList = new Node[nodeListSet.size()];
            nodeListSet.toArray(nodeList);
            nodeListFaciliyID = new String[nodeList.length];
            for (int i = 0; i < nodeList.length; ++i) {
                nodeListFaciliyID[i] = nodeList[i].getFacilityID();
            }
        } else {
            Node node = (Node)this.m_nodeTable.get(facilityID);
            if (node != null) {
                nodeListFaciliyID = new String[]{node.getFacilityID()};
            } else {
                String message = "Facility not found : " + facilityID;
                throw new EJBException(message);
            }
        }
        return nodeListFaciliyID;
    }

    public String[] getSubScopeIDList(String facilityID) {
        Scope scope = (Scope)this.m_scopeTable.get(facilityID);
        if (scope == null) {
            String message = "Facility not found : " + facilityID;
            throw new EJBException(message);
        }
        return scope.getChildrenID();
    }

    public synchronized void fetchMibValue(String facilityId, OIDInfo[] oids, int interval) {
        String[] nodeFid = this.getNodeIDList(facilityId);
        for (int i = 0; i < nodeFid.length; ++i) {
            Node node = (Node)this.m_nodeTable.get(nodeFid[i]);
            if (node == null) {
                String message = "Facility not found : " + nodeFid[i];
                throw new EJBException(message);
            }
            long lastCollectTime = node.fetchMibValue(oids, interval);
            long collectTimeBuffer = this.m_lastCollectTime;
            this.m_lastCollectTime = Math.max(this.m_lastCollectTime, lastCollectTime);
            this.updateFlag = this.m_lastCollectTime != collectTimeBuffer;
        }
    }

    public synchronized CollectedDataInfo getValue(String facilityID, String itemCode, int deviceIndex) {
        double value = Double.NaN;
        Facility facility = (Facility)this.m_scopeTable.get(facilityID);
        if (facility == null) {
            facility = (Facility)this.m_nodeTable.get(facilityID);
        }
        if (facility == null) {
            String message = "Facility not found : " + facilityID;
            throw new EJBException(message);
        }
        value = facility.calcValue(itemCode, deviceIndex);
        CollectedDataInfo ret = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
        if (this.updateFlag) {
            ret.setDate(new Date(this.m_lastCollectTime));
        } else {
            ret.setDate(new Date());
        }
        ret.setValue(value);
        return ret;
    }

    public synchronized CollectedDataInfo getTempValue(String facilityID, String itemCode, int deviceIndex) {
        double value = Double.NaN;
        Facility facility = (Facility)this.m_scopeTable.get(facilityID);
        if (facility == null) {
            facility = (Facility)this.m_nodeTable.get(facilityID);
        }
        if (facility == null) {
            String message = "Facility not found : " + facilityID;
            throw new EJBException(message);
        }
        value = facility.getCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex));
        CollectedDataInfo ret = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
        if (this.m_lastCollectTime == 0L) {
            ret.setDate(new Date());
            ret.setValue(Double.NaN);
        } else {
            ret.setDate(new Date(this.m_lastCollectTime));
            ret.setValue(value);
        }
        return ret;
    }

    public Facility getFacility(String facilityID) {
        Scope scope = (Scope)this.m_scopeTable.get(facilityID);
        Node node = (Node)this.m_nodeTable.get(facilityID);
        if (scope != null && node == null) {
            return scope;
        }
        if (scope == null && node != null) {
            return node;
        }
        String message = "Facility not found : " + facilityID;
        throw new EJBException(message);
    }

    private void setScopeTree(FacilityTreeItem treeItem) {
        FacilityInfo info = treeItem.getData();
        if (info.getType() == 0) {
            this.addScope(info.getFacilityId(), info.getFacilityName(), treeItem.getParent().getData().getFacilityId());
        } else if (info.getType() == 1) {
            this.addNode(info.getFacilityId(), info.getFacilityName(), treeItem.getParent().getData().getFacilityId());
        }
        FacilityTreeItem[] tmpItem = treeItem.getChildren();
        if (tmpItem.length != 0) {
            for (int i = 0; i < tmpItem.length; ++i) {
                this.setScopeTree(tmpItem[i]);
            }
        }
    }

    public boolean isScope(String facilityID) {
        return this.m_scopeTable.get(facilityID) != null;
    }

    public boolean isNode(String facilityID) {
        return this.m_nodeTable.get(facilityID) != null;
    }

    public String[] getAllFacilityIdList() {
        String[] ret = new String[this.m_nodeTable.size() + this.m_scopeTable.size()];
        int i = 0;
        for (Scope scope : this.m_scopeTable.values()) {
            ret[i] = scope.getFacilityID();
            ++i;
        }
        for (Node node : this.m_nodeTable.values()) {
            ret[i] = node.getFacilityID();
            ++i;
        }
        return ret;
    }

    public long getLastCollectTime() {
        return this.m_lastCollectTime;
    }
}

