/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.internal.dialogs.ViewSorter;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "ShowViewDialog";
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 250;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "ShowViewDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_VIEW_ID = "ShowViewDialog.STORE_SELECTED_VIEW_ID";
    private TreeViewer tree;
    private Button okButton;
    private IViewDescriptor[] viewDescs = new IViewDescriptor[0];
    private IViewRegistry viewReg;

    public ShowViewDialog(Shell parentShell, IViewRegistry viewReg) {
        super(parentShell);
        this.viewReg = viewReg;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    protected void cancelPressed() {
        this.viewDescs = new IViewDescriptor[0];
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.ShowView_shellTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.show_view_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createViewer(composite);
        this.layoutTopControl(this.tree.getControl());
        this.restoreWidgetValues();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.tree = new TreeViewer(parent, 2818);
        this.tree.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tree.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tree.setSorter((ViewerSorter)new ViewSorter((ViewRegistry)this.viewReg));
        this.tree.setInput((Object)this.viewReg);
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tree.addDoubleClickListener((IDoubleClickListener)this);
        this.tree.getTree().setFont(parent.getFont());
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (this.tree.isExpandable(element)) {
            this.tree.setExpandedState(element, !this.tree.getExpandedState(element));
        } else if (this.viewDescs.length > 0) {
            this.saveWidgetValues();
            this.setReturnCode(0);
            this.close();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTING_SECTION_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTING_SECTION_NAME);
        }
        return section;
    }

    public IViewDescriptor[] getSelection() {
        return this.viewDescs;
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    protected void restoreWidgetValues() {
        IViewDescriptor viewDesc;
        String selectedViewId;
        IDialogSettings settings = this.getDialogSettings();
        String[] expandedCategoryIds = settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryIds == null) {
            return;
        }
        ViewRegistry reg = (ViewRegistry)this.viewReg;
        ArrayList<IViewCategory> categoriesToExpand = new ArrayList<IViewCategory>(expandedCategoryIds.length);
        int i = 0;
        while (i < expandedCategoryIds.length) {
            IViewCategory category = reg.findCategory(expandedCategoryIds[i]);
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.tree.setExpandedElements(categoriesToExpand.toArray());
        }
        if ((selectedViewId = settings.get(STORE_SELECTED_VIEW_ID)) != null && (viewDesc = reg.find(selectedViewId)) != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)viewDesc), true);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        Object[] expandedElements = this.tree.getExpandedElements();
        String[] expandedCategoryIds = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedCategoryIds[i] = ((IViewCategory)expandedElements[i]).getId();
            ++i;
        }
        settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedCategoryIds);
        String selectedViewId = "";
        if (this.viewDescs.length > 0) {
            selectedViewId = this.viewDescs[0].getId();
        }
        settings.put(STORE_SELECTED_VIEW_ID, selectedViewId);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getSelection().length > 0);
        }
    }

    protected void updateSelection(SelectionChangedEvent event) {
        ArrayList descs = new ArrayList();
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof IViewDescriptor)) continue;
            descs.add(o);
        }
        this.viewDescs = new IViewDescriptor[descs.size()];
        descs.toArray(this.viewDescs);
    }
}

