/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyCreateDialog
extends CommonDialog {
    public static final int WIDTH_PRIORITY = 1;
    public static final int WIDTH_CHECK = 1;
    public static final int WIDTH_COMBO = 2;
    public static final int WIDTH_MAIL_ADDRESS = 7;
    private NotifyInfo inputData = null;
    private ValidateResult validateResult = null;
    private boolean referenceFlg = false;
    private String notifyId = null;
    private Text textNotifyId = null;
    private Text textDescription = null;
    private Button checkStatus = null;
    private Combo comboStatusValidPeriod = null;
    private Button radioStatusDelete = null;
    private Button radioStatusUpdate = null;
    private Combo comboStatusPriority = null;
    private Button checkEvent = null;
    private Button checkEventNormalInfo = null;
    private Button checkEventNormalWarning = null;
    private Button checkEventNormalCritical = null;
    private Button checkEventNormalUnknown = null;
    private Combo comboEventNormalInfo = null;
    private Combo comboEventNormalWarning = null;
    private Combo comboEventNormalCritical = null;
    private Combo comboEventNormalUnknown = null;
    private Button checkEventInhibitionInfo = null;
    private Button checkEventInhibitionWarning = null;
    private Button checkEventInhibitionCritical = null;
    private Button checkEventInhibitionUnknown = null;
    private Combo comboEventInhibitionInfo = null;
    private Combo comboEventInhibitionWarning = null;
    private Combo comboEventInhibitionCritical = null;
    private Combo comboEventInhibitionUnknown = null;
    private Button checkMailInfo = null;
    private Button checkMailWarning = null;
    private Button checkMailCritical = null;
    private Button checkMailUnknown = null;
    private Text textMailInfo = null;
    private Text textMailWarning = null;
    private Text textMailCritical = null;
    private Text textMailUnknown = null;
    private Button radioNoInhibition = null;
    private Button radioInhibitionPeriod = null;
    private Button radioInhibitionFrequency = null;
    private Button radioInhibitionPriority = null;
    private Text textInhibitionPeriod = null;
    private Text textInhibitionFrequency = null;

    public NotifyCreateDialog(Shell parent) {
        super(parent);
    }

    public NotifyCreateDialog(Shell parent, String notifyId, boolean referenceFlg) {
        super(parent);
        this.notifyId = notifyId;
        this.referenceFlg = referenceFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.notify.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("notify.id")) + " : ");
        this.textNotifyId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textNotifyId.setLayoutData((Object)gridData);
        if (this.notifyId != null && !"".equals(this.notifyId.trim())) {
            this.textNotifyId.setEnabled(false);
        }
        this.textNotifyId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.checkStatus = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.checkStatus.setLayoutData((Object)gridData);
        this.checkStatus.setText(String.valueOf(Messages.getString("notifies.status")) + " : ");
        this.checkStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForStatus(NotifyCreateDialog.this.checkStatus.getSelection());
            }
        });
        Group groupStatus1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus1.setLayoutData((Object)gridData);
        label = new Label((Composite)groupStatus1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("notify.status.valid.period")) + " : ");
        this.comboStatusValidPeriod = new Combo((Composite)groupStatus1, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusValidPeriod.setLayoutData((Object)gridData);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_UNLIMITED);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_10);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_20);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_30);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_1);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_3);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_6);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_12);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_DAY_1);
        label = new Label((Composite)groupStatus1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupStatus1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("notify.status.invalid.period.treatment")) + " : ");
        Group groupStatus2 = new Group((Composite)groupStatus1, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus2.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus2.setLayoutData((Object)gridData);
        this.radioStatusDelete = new Button((Composite)groupStatus2, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusDelete.setLayoutData((Object)gridData);
        this.radioStatusDelete.setText(Messages.getString("notify.status.invalid.period.delete"));
        this.radioStatusUpdate = new Button((Composite)groupStatus2, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusUpdate.setLayoutData((Object)gridData);
        this.radioStatusUpdate.setText(Messages.getString("notify.status.invalid.period.updatet"));
        this.radioStatusUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.comboStatusPriority.setEnabled(NotifyCreateDialog.this.radioStatusUpdate.getSelection());
            }
        });
        label = new Label((Composite)groupStatus2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("priority")) + " : ");
        this.comboStatusPriority = new Combo((Composite)groupStatus2, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusPriority.setLayoutData((Object)gridData);
        this.comboStatusPriority.add(PriorityConstant.STRING_CRITICAL);
        this.comboStatusPriority.add(PriorityConstant.STRING_WARNING);
        this.comboStatusPriority.add(PriorityConstant.STRING_INFO);
        this.comboStatusPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.comboStatusPriority.setText(PriorityConstant.STRING_WARNING);
        label = new Label((Composite)groupStatus2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.checkEvent = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.checkEvent.setLayoutData((Object)gridData);
        this.checkEvent.setText(String.valueOf(Messages.getString("notifies.event")) + " : ");
        this.checkEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForEvent(NotifyCreateDialog.this.checkEvent.getSelection());
            }
        });
        Group groupEvent1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent1.setLayoutData((Object)gridData);
        Group groupEvent2 = new Group((Composite)groupEvent1, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent2.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent2.setLayoutData((Object)gridData);
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("notify.event.treatment.normal"));
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("notify.event.state.normal"));
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("notify.event.treatment.inhibition"));
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("notify.event.state.inhibition"));
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("notify.event.treatment.mail"));
        label = new Label((Composite)groupEvent2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("email.address.ssv")) + " : ");
        label = this.getLabelPriority((Composite)groupEvent2, Messages.getString("info"), PriorityColorConstant.COLOR_INFO);
        this.checkEventNormalInfo = this.getCheckEventNormal((Composite)groupEvent2);
        this.comboEventNormalInfo = this.getComboEventNormal((Composite)groupEvent2);
        this.checkEventInhibitionInfo = this.getCheckEventInhibition((Composite)groupEvent2);
        this.comboEventInhibitionInfo = this.getComboEventInhibition((Composite)groupEvent2);
        this.checkMailInfo = this.getCheckMail((Composite)groupEvent2);
        this.textMailInfo = this.getTextMail((Composite)groupEvent2);
        this.checkEventNormalInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForEvent(NotifyCreateDialog.this.checkEventNormalInfo.getSelection(), NotifyCreateDialog.this.comboEventNormalInfo, NotifyCreateDialog.this.checkEventInhibitionInfo, NotifyCreateDialog.this.comboEventInhibitionInfo, NotifyCreateDialog.this.checkMailInfo, NotifyCreateDialog.this.textMailInfo);
            }
        });
        this.comboEventNormalInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventNormalInfo.getText())) {
                    NotifyCreateDialog.this.comboEventInhibitionInfo.setText(EventConfirmConstant.STRING_DESTRUCTION);
                }
            }
        });
        this.checkEventInhibitionInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.comboEventInhibitionInfo.setEnabled(NotifyCreateDialog.this.checkEventInhibitionInfo.getSelection());
            }
        });
        this.comboEventInhibitionInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventInhibitionInfo.getText())) {
                    NotifyCreateDialog.this.comboEventNormalInfo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
                }
            }
        });
        this.checkMailInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textMailInfo.setEnabled(NotifyCreateDialog.this.checkMailInfo.getSelection());
            }
        });
        label = this.getLabelPriority((Composite)groupEvent2, Messages.getString("warning"), PriorityColorConstant.COLOR_WARNING);
        this.checkEventNormalWarning = this.getCheckEventNormal((Composite)groupEvent2);
        this.comboEventNormalWarning = this.getComboEventNormal((Composite)groupEvent2);
        this.checkEventInhibitionWarning = this.getCheckEventInhibition((Composite)groupEvent2);
        this.comboEventInhibitionWarning = this.getComboEventInhibition((Composite)groupEvent2);
        this.checkMailWarning = this.getCheckMail((Composite)groupEvent2);
        this.textMailWarning = this.getTextMail((Composite)groupEvent2);
        this.checkEventNormalWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForEvent(NotifyCreateDialog.this.checkEventNormalWarning.getSelection(), NotifyCreateDialog.this.comboEventNormalWarning, NotifyCreateDialog.this.checkEventInhibitionWarning, NotifyCreateDialog.this.comboEventInhibitionWarning, NotifyCreateDialog.this.checkMailWarning, NotifyCreateDialog.this.textMailWarning);
            }
        });
        this.comboEventNormalWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventNormalWarning.getText())) {
                    NotifyCreateDialog.this.comboEventInhibitionWarning.setText(EventConfirmConstant.STRING_DESTRUCTION);
                }
            }
        });
        this.checkEventInhibitionWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.comboEventInhibitionWarning.setEnabled(NotifyCreateDialog.this.checkEventInhibitionWarning.getSelection());
            }
        });
        this.comboEventInhibitionWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventInhibitionWarning.getText())) {
                    NotifyCreateDialog.this.comboEventNormalWarning.setText(EventConfirmConstant.STRING_UNCONFIRMED);
                }
            }
        });
        this.checkMailWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textMailWarning.setEnabled(NotifyCreateDialog.this.checkMailWarning.getSelection());
            }
        });
        label = this.getLabelPriority((Composite)groupEvent2, Messages.getString("critical"), PriorityColorConstant.COLOR_CRITICAL);
        this.checkEventNormalCritical = this.getCheckEventNormal((Composite)groupEvent2);
        this.comboEventNormalCritical = this.getComboEventNormal((Composite)groupEvent2);
        this.checkEventInhibitionCritical = this.getCheckEventInhibition((Composite)groupEvent2);
        this.comboEventInhibitionCritical = this.getComboEventInhibition((Composite)groupEvent2);
        this.checkMailCritical = this.getCheckMail((Composite)groupEvent2);
        this.textMailCritical = this.getTextMail((Composite)groupEvent2);
        this.checkEventNormalCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForEvent(NotifyCreateDialog.this.checkEventNormalCritical.getSelection(), NotifyCreateDialog.this.comboEventNormalCritical, NotifyCreateDialog.this.checkEventInhibitionCritical, NotifyCreateDialog.this.comboEventInhibitionCritical, NotifyCreateDialog.this.checkMailCritical, NotifyCreateDialog.this.textMailCritical);
            }
        });
        this.comboEventNormalCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventNormalCritical.getText())) {
                    NotifyCreateDialog.this.comboEventInhibitionCritical.setText(EventConfirmConstant.STRING_DESTRUCTION);
                }
            }
        });
        this.checkEventInhibitionCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.comboEventInhibitionCritical.setEnabled(NotifyCreateDialog.this.checkEventInhibitionCritical.getSelection());
            }
        });
        this.comboEventInhibitionCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventInhibitionCritical.getText())) {
                    NotifyCreateDialog.this.comboEventNormalCritical.setText(EventConfirmConstant.STRING_UNCONFIRMED);
                }
            }
        });
        this.checkMailCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textMailCritical.setEnabled(NotifyCreateDialog.this.checkMailCritical.getSelection());
            }
        });
        label = this.getLabelPriority((Composite)groupEvent2, Messages.getString("unknown"), PriorityColorConstant.COLOR_UNKNOWN);
        this.checkEventNormalUnknown = this.getCheckEventNormal((Composite)groupEvent2);
        this.comboEventNormalUnknown = this.getComboEventNormal((Composite)groupEvent2);
        this.checkEventInhibitionUnknown = this.getCheckEventInhibition((Composite)groupEvent2);
        this.comboEventInhibitionUnknown = this.getComboEventInhibition((Composite)groupEvent2);
        this.checkMailUnknown = this.getCheckMail((Composite)groupEvent2);
        this.textMailUnknown = this.getTextMail((Composite)groupEvent2);
        this.checkEventNormalUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.setEnabledForEvent(NotifyCreateDialog.this.checkEventNormalUnknown.getSelection(), NotifyCreateDialog.this.comboEventNormalUnknown, NotifyCreateDialog.this.checkEventInhibitionUnknown, NotifyCreateDialog.this.comboEventInhibitionUnknown, NotifyCreateDialog.this.checkMailUnknown, NotifyCreateDialog.this.textMailUnknown);
            }
        });
        this.comboEventNormalUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventNormalUnknown.getText())) {
                    NotifyCreateDialog.this.comboEventInhibitionUnknown.setText(EventConfirmConstant.STRING_DESTRUCTION);
                }
            }
        });
        this.checkEventInhibitionUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.comboEventInhibitionUnknown.setEnabled(NotifyCreateDialog.this.checkEventInhibitionUnknown.getSelection());
            }
        });
        this.comboEventInhibitionUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EventConfirmConstant.STRING_CONFIRMED.equals(NotifyCreateDialog.this.comboEventInhibitionUnknown.getText())) {
                    NotifyCreateDialog.this.comboEventNormalUnknown.setText(EventConfirmConstant.STRING_UNCONFIRMED);
                }
            }
        });
        this.checkMailUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textMailUnknown.setEnabled(NotifyCreateDialog.this.checkMailUnknown.getSelection());
            }
        });
        label = new Label((Composite)groupEvent1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("notify.event.inhibition")) + " : ");
        Group groupEvent3 = new Group((Composite)groupEvent1, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent3.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent3.setLayoutData((Object)gridData);
        label = new Label((Composite)groupEvent3, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("notify.event.inhibition.timing")) + " : ");
        Group groupEvent4 = new Group((Composite)groupEvent3, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent4.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent4.setLayoutData((Object)gridData);
        this.radioNoInhibition = new Button((Composite)groupEvent4, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioNoInhibition.setLayoutData((Object)gridData);
        this.radioNoInhibition.setText(Messages.getString("suppress.no"));
        this.radioInhibitionPeriod = new Button((Composite)groupEvent4, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPeriod.setLayoutData((Object)gridData);
        this.radioInhibitionPeriod.setText(String.valueOf(Messages.getString("suppress.by.time.interval")) + " : ");
        this.radioInhibitionPeriod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textInhibitionPeriod.setEnabled(NotifyCreateDialog.this.radioInhibitionPeriod.getSelection());
                NotifyCreateDialog.this.textInhibitionFrequency.setEnabled(NotifyCreateDialog.this.radioInhibitionFrequency.getSelection());
            }
        });
        this.textInhibitionPeriod = new Text((Composite)groupEvent4, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionPeriod.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(1, Short.MAX_VALUE));
        this.textInhibitionPeriod.setLayoutData((Object)gridData);
        label = new Label((Composite)groupEvent4, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.radioInhibitionFrequency = new Button((Composite)groupEvent4, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionFrequency.setLayoutData((Object)gridData);
        this.radioInhibitionFrequency.setText(String.valueOf(Messages.getString("suppress.by.counter")) + " : ");
        this.radioInhibitionFrequency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textInhibitionPeriod.setEnabled(NotifyCreateDialog.this.radioInhibitionPeriod.getSelection());
                NotifyCreateDialog.this.textInhibitionFrequency.setEnabled(NotifyCreateDialog.this.radioInhibitionFrequency.getSelection());
            }
        });
        this.textInhibitionFrequency = new Text((Composite)groupEvent4, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionFrequency.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(1, Short.MAX_VALUE));
        this.textInhibitionFrequency.setLayoutData((Object)gridData);
        label = new Label((Composite)groupEvent4, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.radioInhibitionPriority = new Button((Composite)groupEvent4, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPriority.setLayoutData((Object)gridData);
        this.radioInhibitionPriority.setText(String.valueOf(Messages.getString("suppress.by.priority")) + " : ");
        this.radioInhibitionPriority.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyCreateDialog.this.textInhibitionPeriod.setEnabled(NotifyCreateDialog.this.radioInhibitionPeriod.getSelection());
                NotifyCreateDialog.this.textInhibitionFrequency.setEnabled(NotifyCreateDialog.this.radioInhibitionFrequency.getSelection());
            }
        });
        label = new Label((Composite)groupEvent4, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 11;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(780, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        NotifyInfo info = null;
        info = this.notifyId != null ? new GetNotify().getNotify(this.notifyId) : new NotifyInfo();
        this.setInputData(info);
    }

    public NotifyInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(NotifyInfo notify) {
        this.inputData = notify;
        if (notify.getNotifyId() != null) {
            this.textNotifyId.setText(notify.getNotifyId());
        }
        if (notify.getDescription() != null) {
            this.textDescription.setText(notify.getDescription());
        }
        if (notify.getStatusFlg() == 1) {
            this.checkStatus.setSelection(true);
        } else {
            this.checkStatus.setSelection(false);
        }
        if (notify.getStatusValidPeriod() != null) {
            this.comboStatusValidPeriod.setText(StatusValidPeriodConstant.typeToString(notify.getStatusValidPeriod()));
        }
        if (notify.getStatusInvalidFlg() != null && notify.getStatusInvalidFlg() == 11) {
            this.radioStatusDelete.setSelection(true);
        } else {
            this.radioStatusUpdate.setSelection(true);
        }
        this.comboStatusPriority.setText(PriorityConstant.typeToString(notify.getStatusUpdatePriority()));
        if (notify.getEventFlg() != null && notify.getEventFlg() == 1) {
            this.checkEvent.setSelection(true);
        } else {
            this.checkEvent.setSelection(false);
        }
        ArrayList<NotifyEventInfo> list = notify.getNotifyEventInfo();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                NotifyEventInfo event = list.get(index);
                if (event != null) {
                    if (3 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.checkEventNormalInfo, this.comboEventNormalInfo, this.checkEventInhibitionInfo, this.comboEventInhibitionInfo, this.checkMailInfo, this.textMailInfo);
                    } else if (2 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.checkEventNormalWarning, this.comboEventNormalWarning, this.checkEventInhibitionWarning, this.comboEventInhibitionWarning, this.checkMailWarning, this.textMailWarning);
                    } else if (event.getPriority() == 0) {
                        this.setInputDataForEvent(event, this.checkEventNormalCritical, this.comboEventNormalCritical, this.checkEventInhibitionCritical, this.comboEventInhibitionCritical, this.checkMailCritical, this.textMailCritical);
                    } else if (1 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.checkEventNormalUnknown, this.comboEventNormalUnknown, this.checkEventInhibitionUnknown, this.comboEventInhibitionUnknown, this.checkMailUnknown, this.textMailUnknown);
                    }
                }
                ++index;
            }
        }
        if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg() == 2) {
            this.radioInhibitionPeriod.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg() == 1) {
            this.radioInhibitionFrequency.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg() == 3) {
            this.radioInhibitionPriority.setSelection(true);
        } else {
            this.radioNoInhibition.setSelection(true);
        }
        if (notify.getInhibitionPeriod() != null) {
            this.textInhibitionPeriod.setText(notify.getInhibitionPeriod().toString());
        }
        if (notify.getInhibitionFrequency() != null) {
            this.textInhibitionFrequency.setText(notify.getInhibitionFrequency().toString());
        }
        if (this.referenceFlg) {
            this.setEnabled(false);
        } else {
            this.setEnabledForStatus(this.checkStatus.getSelection());
            this.setEnabledForEvent(this.checkEvent.getSelection());
        }
    }

    protected NotifyInfo createInputData() {
        NotifyInfo info;
        block25: {
            block24: {
                info = new NotifyInfo();
                if (this.textNotifyId.getText() == null || "".equals(this.textNotifyId.getText().trim())) {
                    this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.10"));
                    return null;
                }
                info.setNotifyId(this.textNotifyId.getText());
                if (this.textDescription.getText() != null && !"".equals(this.textDescription.getText().trim())) {
                    info.setDescription(this.textDescription.getText());
                }
                if (this.checkStatus.getSelection()) {
                    info.setStatusFlg(1);
                } else {
                    info.setStatusFlg(0);
                }
                if (this.comboStatusValidPeriod.getText() != null && !"".equals(this.comboStatusValidPeriod.getText().trim())) {
                    info.setStatusValidPeriod(new Integer(StatusValidPeriodConstant.stringToType(this.comboStatusValidPeriod.getText())));
                } else if (this.checkStatus.getSelection()) {
                    this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.12"));
                    return null;
                }
                if (this.radioStatusDelete.getSelection()) {
                    info.setStatusInvalidFlg(11);
                } else {
                    info.setStatusInvalidFlg(12);
                }
                if (this.comboStatusPriority.getText() != null && !"".equals(this.comboStatusPriority.getText().trim())) {
                    info.setStatusUpdatePriority(new Integer(PriorityConstant.stringToType(this.comboStatusPriority.getText())));
                }
                if (this.checkEvent.getSelection()) {
                    info.setEventFlg(1);
                } else {
                    info.setEventFlg(0);
                }
                if (!(!this.checkEvent.getSelection() || this.checkEventNormalInfo.getSelection() || this.checkEventNormalWarning.getSelection() || this.checkEventNormalCritical.getSelection() || this.checkEventNormalUnknown.getSelection())) {
                    this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.13"));
                    return null;
                }
                ArrayList<NotifyEventInfo> list = new ArrayList<NotifyEventInfo>();
                list = this.createInputDataForEvent(list, 3, this.checkEventNormalInfo, this.comboEventNormalInfo, this.checkEventInhibitionInfo, this.comboEventInhibitionInfo, this.checkMailInfo, this.textMailInfo);
                list = this.createInputDataForEvent(list, 2, this.checkEventNormalWarning, this.comboEventNormalWarning, this.checkEventInhibitionWarning, this.comboEventInhibitionWarning, this.checkMailWarning, this.textMailWarning);
                list = this.createInputDataForEvent(list, 0, this.checkEventNormalCritical, this.comboEventNormalCritical, this.checkEventInhibitionCritical, this.comboEventInhibitionCritical, this.checkMailCritical, this.textMailCritical);
                if ((list = this.createInputDataForEvent(list, 1, this.checkEventNormalUnknown, this.comboEventNormalUnknown, this.checkEventInhibitionUnknown, this.comboEventInhibitionUnknown, this.checkMailUnknown, this.textMailUnknown)) == null) {
                    return null;
                }
                info.setNotifyEventInfo(list);
                if (this.radioInhibitionPeriod.getSelection()) {
                    info.setInhibitionFlg(2);
                } else if (this.radioInhibitionFrequency.getSelection()) {
                    info.setInhibitionFlg(1);
                } else if (this.radioInhibitionPriority.getSelection()) {
                    info.setInhibitionFlg(3);
                } else {
                    info.setInhibitionFlg(0);
                }
                try {
                    info.setInhibitionPeriod(Integer.parseInt(this.textInhibitionPeriod.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.checkEvent.getSelection() || !this.radioInhibitionPeriod.getSelection()) break block24;
                    this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.14"));
                    return null;
                }
            }
            try {
                info.setInhibitionFrequency(Integer.parseInt(this.textInhibitionFrequency.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (!this.checkEvent.getSelection() || !this.radioInhibitionFrequency.getSelection()) break block25;
                this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.15"));
                return null;
            }
        }
        return info;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        NotifyInfo info = this.getInputData();
        if (info != null) {
            result = this.notifyId == null ? new AddNotify().add(info) : new ModifyNotify().modify(info);
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    protected Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    protected Button getCheckEventNormal(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Combo getComboEventNormal(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(EventConfirmConstant.STRING_UNCONFIRMED);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
        return combo;
    }

    protected Button getCheckEventInhibition(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Combo getComboEventInhibition(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.add(EventConfirmConstant.STRING_DESTRUCTION);
        combo.setText(EventConfirmConstant.STRING_CONFIRMED);
        return combo;
    }

    protected Button getCheckMail(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Text getTextMail(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        return text;
    }

    protected ArrayList<NotifyEventInfo> createInputDataForEvent(ArrayList<NotifyEventInfo> list, int priority, Button checkEventNormal, Combo comboEventNormal, Button checkEventInhibition, Combo comboEventInhibition, Button checkMail, Text textMail) {
        if (list == null) {
            return null;
        }
        NotifyEventInfo event = new NotifyEventInfo();
        event.setPriority(priority);
        if (checkEventNormal.getSelection()) {
            event.setEventNormalFlg(new Integer(1));
        } else {
            event.setEventNormalFlg(new Integer(0));
        }
        if (comboEventNormal.getText() != null && !"".equals(comboEventNormal.getText().trim())) {
            event.setEventNormalState(new Integer(EventConfirmConstant.stringToType(comboEventNormal.getText())));
        }
        if (checkEventInhibition.getSelection()) {
            if (this.checkEvent.getSelection() && checkEventNormal.getSelection() && this.radioNoInhibition.getSelection()) {
                this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.16"));
                return null;
            }
            event.setEventInhibitionFlg(new Integer(1));
        } else {
            event.setEventInhibitionFlg(new Integer(0));
        }
        if (comboEventInhibition.getText() != null && !"".equals(comboEventInhibition.getText().trim())) {
            event.setEventInhibitionState(new Integer(EventConfirmConstant.stringToType(comboEventInhibition.getText())));
        }
        if (checkMail.getSelection()) {
            event.setMailFlg(new Integer(1));
        } else {
            event.setMailFlg(new Integer(0));
        }
        if (textMail.getText() != null && !"".equals(textMail.getText().trim())) {
            StringTokenizer t = new StringTokenizer(textMail.getText(), ";");
            while (t.hasMoreTokens()) {
                String mailAddress = t.nextToken();
                String[] attr = mailAddress.split("@");
                if (attr.length == 2) continue;
                this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.18"));
                return null;
            }
            event.setMailAddress(textMail.getText());
        } else if (this.checkEvent.getSelection() && checkEventNormal.getSelection() && checkMail.getSelection()) {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.notify.17"));
            return null;
        }
        list.add(event);
        return list;
    }

    private void setInputDataForEvent(NotifyEventInfo info, Button checkEventNormal, Combo comboEventNormal, Button checkEventInhibition, Combo comboEventInhibition, Button checkMail, Text textMail) {
        if (info.getEventNormalFlg() != null && info.getEventNormalFlg() == 1) {
            checkEventNormal.setSelection(true);
        }
        if (info.getEventNormalState() != null) {
            comboEventNormal.setText(EventConfirmConstant.typeToString(info.getEventNormalState()));
        }
        if (info.getEventInhibitionFlg() != null && info.getEventInhibitionFlg() == 1) {
            checkEventInhibition.setSelection(true);
        }
        if (info.getEventInhibitionState() != null) {
            comboEventInhibition.setText(EventConfirmConstant.typeToString(info.getEventInhibitionState()));
        }
        if (info.getMailFlg() != null && info.getMailFlg() == 1) {
            checkMail.setSelection(true);
        }
        if (info.getMailAddress() != null) {
            textMail.setText(info.getMailAddress());
        }
    }

    private void setEnabled(boolean enable) {
        this.textDescription.setEnabled(enable);
        this.checkStatus.setEnabled(enable);
        this.checkEvent.setEnabled(enable);
        this.setEnabledForStatus(enable);
        this.setEnabledForEvent(enable);
    }

    private void setEnabledForStatus(boolean enable) {
        this.comboStatusValidPeriod.setEnabled(enable);
        this.radioStatusDelete.setEnabled(enable);
        this.radioStatusUpdate.setEnabled(enable);
        if (enable) {
            this.comboStatusPriority.setEnabled(this.radioStatusUpdate.getSelection());
        } else {
            this.comboStatusPriority.setEnabled(enable);
        }
    }

    private void setEnabledForEvent(boolean enable) {
        this.setEnabledForEvents(enable, this.checkEventNormalInfo, this.comboEventNormalInfo, this.checkEventInhibitionInfo, this.comboEventInhibitionInfo, this.checkMailInfo, this.textMailInfo);
        this.setEnabledForEvents(enable, this.checkEventNormalWarning, this.comboEventNormalWarning, this.checkEventInhibitionWarning, this.comboEventInhibitionWarning, this.checkMailWarning, this.textMailWarning);
        this.setEnabledForEvents(enable, this.checkEventNormalCritical, this.comboEventNormalCritical, this.checkEventInhibitionCritical, this.comboEventInhibitionCritical, this.checkMailCritical, this.textMailCritical);
        this.setEnabledForEvents(enable, this.checkEventNormalUnknown, this.comboEventNormalUnknown, this.checkEventInhibitionUnknown, this.comboEventInhibitionUnknown, this.checkMailUnknown, this.textMailUnknown);
        this.radioNoInhibition.setEnabled(enable);
        this.radioInhibitionPeriod.setEnabled(enable);
        this.radioInhibitionFrequency.setEnabled(enable);
        this.radioInhibitionPriority.setEnabled(enable);
        if (enable) {
            this.textInhibitionPeriod.setEnabled(this.radioInhibitionPeriod.getSelection());
        } else {
            this.textInhibitionPeriod.setEnabled(false);
        }
        if (enable) {
            this.textInhibitionFrequency.setEnabled(this.radioInhibitionFrequency.getSelection());
        } else {
            this.textInhibitionFrequency.setEnabled(false);
        }
    }

    private void setEnabledForEvents(boolean enable, Button checkEventNormal, Combo comboEventNormal, Button checkEventInhibition, Combo comboEventInhibition, Button checkMail, Text textMail) {
        checkEventNormal.setEnabled(enable);
        if (enable) {
            this.setEnabledForEvent(checkEventNormal.getSelection(), comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        } else {
            this.setEnabledForEvent(false, comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        }
    }

    private void setEnabledForEvent(boolean enable, Combo comboEventNormal, Button checkEventInhibition, Combo comboEventInhibition, Button checkMail, Text textMail) {
        if (enable) {
            comboEventNormal.setEnabled(true);
            checkEventInhibition.setEnabled(true);
            comboEventInhibition.setEnabled(checkEventInhibition.getSelection());
            checkMail.setEnabled(true);
            textMail.setEnabled(checkMail.getSelection());
        } else {
            comboEventNormal.setEnabled(false);
            checkEventInhibition.setEnabled(false);
            comboEventInhibition.setEnabled(false);
            checkMail.setEnabled(false);
            textMail.setEnabled(false);
        }
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.referenceFlg) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }
}

