/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.preference;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ClusterControlCorePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EJB_URL = "ejbUrl";
    StringFieldEditor url = null;

    public ClusterControlCorePreferencePage() {
        super(1);
        this.setPreferenceStore(ClusterControlPlugin.getDefault().getPreferenceStore());
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(EJB_URL, "jnp://localhost:1099");
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group group = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString("jboss.connection.setting"));
        this.url = new StringFieldEditor(EJB_URL, Messages.getString("connection.url"), (Composite)group);
        this.url.setTextLimit(256);
        this.addField((FieldEditor)this.url);
    }

    public boolean performOk() {
        if (this.url.getStringValue().length() >= 0 && !this.url.getStringValue().startsWith("jnp://")) {
            MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.hinemos.9"));
            return false;
        }
        boolean result = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        store.getString(EJB_URL);
        return result;
    }

    public void init(IWorkbench workbench) {
    }
}

