/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;

public class JRImageSaver {
    public static void saveImageDataToFile(byte[] imageData, File file) throws JRException {
        FileOutputStream fos = null;
        ByteArrayInputStream bais = null;
        try {
            fos = new FileOutputStream(file);
            bais = new ByteArrayInputStream(imageData);
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = bais.read(bytes)) > 0) {
                fos.write(bytes, 0, ln);
            }
            fos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving image data : " + file, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void saveImageDataToOutputStream(byte[] imageData, OutputStream os) throws JRException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(imageData);
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = bais.read(bytes)) > 0) {
                os.write(bytes, 0, ln);
            }
            os.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving image data to output stream.", e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

