/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata.unmarshalling;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.metadata.unmarshalling.BasicElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.metadata.unmarshalling.NamespaceBinding;

public interface BindingCursor {
    public void startElement(String var1, String var2);

    public void endElement(String var1, String var2);

    public Object getElementBinding();

    public Object getParentElementBinding();

    public static class Factory {
        private Factory() {
        }

        public static BindingCursor newCursor(DocumentBinding doc) {
            return doc == null ? NoopBindingCursor.INSTANCE : new BindingCursorImpl(doc);
        }

        private static class NoopBindingCursor
        implements BindingCursor {
            static final BindingCursor INSTANCE = new NoopBindingCursor();

            private NoopBindingCursor() {
            }

            public void startElement(String namespaceURI, String localName) {
            }

            public void endElement(String namespaceURI, String localName) {
            }

            public Object getElementBinding() {
                return null;
            }

            public Object getParentElementBinding() {
                return null;
            }
        }

        private static class BindingCursorImpl
        implements BindingCursor {
            private final DocumentBinding docBinding;
            private final LinkedList stack = new LinkedList();

            public BindingCursorImpl(DocumentBinding docBinding) {
                this.docBinding = docBinding;
            }

            public void startElement(String namespaceURI, String localName) {
                BasicElementBinding elBinding;
                if (this.stack.isEmpty()) {
                    NamespaceBinding nsBinding = this.docBinding.getNamespace(namespaceURI);
                    elBinding = nsBinding.getTopElement(localName);
                } else {
                    elBinding = (BasicElementBinding)this.stack.getLast();
                    elBinding = elBinding.getElement(new QName(namespaceURI, localName));
                }
                this.stack.addLast(elBinding);
            }

            public void endElement(String namespaceURI, String localName) {
                this.stack.removeLast();
            }

            public Object getElementBinding() {
                return (BasicElementBinding)this.stack.getLast();
            }

            public Object getParentElementBinding() {
                return this.stack.size() - 2 >= 0 ? (BasicElementBinding)this.stack.get(this.stack.size() - 2) : null;
            }
        }
    }
}

