/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.logagent.Agent;
import com.clustercontrol.logagent.SendQueue;
import com.clustercontrol.logagent.TransferLogManager;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveTopic
implements MessageListener,
ExceptionListener {
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    private static final String TOPIC_USER_NAME = "topic.user.name";
    private static final String TOPIC_USER_PASSWORD = "topic.user.password";
    protected Agent m_agent;
    protected ArrayList m_facilityIdList;
    protected SendQueue m_sendQueue;
    private Properties m_props;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    protected TransferLogManager m_logManager;
    private long m_interval = 30000L;
    private boolean m_errFlg = false;
    protected static Timer m_timer = new Timer(true);
    private static Log log = LogFactory.getLog(ReceiveTopic.class);

    public ReceiveTopic(Agent agent, Collection facilityIdList, TransferLogManager logManager, SendQueue sendQueue, Properties props) {
        this.m_agent = agent;
        this.m_logManager = logManager;
        this.m_facilityIdList = new ArrayList(facilityIdList);
        this.m_sendQueue = sendQueue;
        this.m_props = props;
        String interval = this.m_props.getProperty("receivetopic.reconnection.interval");
        if (interval != null) {
            try {
                this.m_interval = Integer.parseInt(interval) * 1000;
            }
            catch (NumberFormatException e) {
                log.error((Object)"receivetopic.reconnection.interval", (Throwable)e);
            }
        }
        this.initial();
    }

    public synchronized void setFacilityIdList(Collection facilityIdList) {
        if (facilityIdList.size() == this.m_facilityIdList.size() && this.m_facilityIdList.containsAll(facilityIdList)) {
            return;
        }
        ArrayList removeFacilityList = new ArrayList(this.m_facilityIdList);
        removeFacilityList.removeAll(facilityIdList);
        for (String facility : removeFacilityList) {
            this.m_logManager.removeTransferLogInfo(facility);
        }
        ArrayList oldFacilityList = new ArrayList(this.m_facilityIdList);
        this.m_facilityIdList = new ArrayList(facilityIdList);
        if (!this.isErrFlg()) {
            if (this.initialTopic()) {
                for (String facility : facilityIdList) {
                    if (this.m_sendQueue.put(facility)) continue;
                    this.m_facilityIdList.remove(facility);
                }
            } else {
                this.m_facilityIdList = new ArrayList(oldFacilityList);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        Serializable obj;
        boolean initFlg;
        String facilityId;
        log.debug((Object)"onMessage start");
        try {
            facilityId = message.getStringProperty("FacilityId");
            initFlg = message.getBooleanProperty("Init");
            log.debug((Object)("onMessage target facility : " + facilityId));
        }
        catch (JMSException e1) {
            log.error((Object)"\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63", (Throwable)e1);
            return;
        }
        if (!(message instanceof ObjectMessage)) {
            log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + message.getClass()));
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            obj = objectMessage.getObject();
        }
        catch (JMSException e) {
            log.error((Object)"\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63", (Throwable)e);
            return;
        }
        if (!(obj instanceof ArrayList)) {
            log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + obj.toString()));
            return;
        }
        log.debug((Object)"onMessage get ArrayList");
        ArrayList list = (ArrayList)obj;
        if (log.isDebugEnabled()) {
            for (LogTransferFileInfo info : list) {
                log.debug((Object)("  " + info.getTransferId() + ", " + info.getFilePath()));
            }
        }
        if (initFlg) {
            log.debug((Object)"\u30ed\u30b0\u8ee2\u9001\u60c5\u5831\u3092\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5");
            this.m_logManager.refreshRunTransferLog(facilityId, list);
        }
        this.m_logManager.setTransferLogInfo(facilityId, list);
        log.debug((Object)"onMessage end");
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0.getMessage(), (Throwable)arg0);
        this.m_agent.reConnection();
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            m_timer.schedule((TimerTask)new ReSetupTask(), this.m_interval, this.m_interval);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean isErrFlg() {
        return this.m_errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
            this.m_con = this.m_props.getProperty(TOPIC_USER_NAME) != null ? this.m_factory.createTopicConnection(this.m_props.getProperty(TOPIC_USER_NAME), this.m_props.getProperty(TOPIC_USER_PASSWORD)) : this.m_factory.createTopicConnection();
            this.m_session = this.m_con.createTopicSession(false, 1);
            this.m_topic = (Topic)con.lookup("topic/clustercontrolLogtransferUpdate");
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.initialTopic();
            Iterator iter = this.m_facilityIdList.iterator();
            while (iter.hasNext()) {
                this.m_sendQueue.put(iter.next());
            }
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            StringBuffer msgSelector = new StringBuffer();
            Iterator iter = this.m_facilityIdList.iterator();
            while (iter.hasNext()) {
                String facilityId = (String)iter.next();
                msgSelector.append("FacilityId='");
                msgSelector.append(facilityId);
                msgSelector.append("'");
                if (!iter.hasNext()) continue;
                msgSelector.append(" OR ");
            }
            if (msgSelector.length() != 0) {
                this.m_subscriber = this.m_session.createSubscriber(this.m_topic, msgSelector.toString(), false);
                this.m_subscriber.setMessageListener((MessageListener)this);
            } else {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u304c\u306a\u3044\u306e\u3067\u3001\u4f55\u3082\u3057\u306a\u3044");
            }
        }
        catch (Exception e) {
            log.error((Object)"TopicInit", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public synchronized void reconnect() {
        this.setErrFlg(true);
        this.terminate();
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (ReceiveTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

