/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import javax.naming.Context;
import javax.xml.ws.WebServiceException;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;

public class WebServiceRefInjector
implements EncInjector {
    private static final Logger log = Logger.getLogger(WebServiceRefInjector.class);
    private String name;
    private ServiceRefMetaData sref;

    public WebServiceRefInjector(String name, AnnotatedElement anElement, ServiceRefMetaData sref) {
        this.name = name;
        this.sref = sref;
        this.sref.setAnnotatedElement((Object)anElement);
    }

    public void inject(InjectionContainer container) {
        try {
            Context encCtx = container.getEnc();
            EJBContainer ejbContainer = (EJBContainer)container;
            DeploymentUnit unit = ejbContainer.getDeploymentUnit();
            URL rootURL = unit.getUrl();
            ClassLoader loader = unit.getClassLoader();
            URLLoaderAdapter vfsRoot = new URLLoaderAdapter(rootURL);
            new ServiceRefDelegate().bindServiceRef(encCtx, this.name, (UnifiedVirtualFile)vfsRoot, loader, this.sref);
            log.debug("@WebServiceRef bound [env=" + this.name + "]");
        }
        catch (Exception e) {
            throw new WebServiceException("Unable to bind @WebServiceRef [enc=" + this.name + "]", (Throwable)e);
        }
    }

    public String toString() {
        return super.toString() + "{enc=" + this.name + "}";
    }
}

