/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;

/**
 * RoleのBMP Entity Beanクラス
 * 
 * @ejb.bean name="Role"
 *	   jndi-name="Role"
 *	   type="BMP"
 *
 * @ejb.dao class="com.clustercontrol.accesscontrol.dao.RoleDAO"
 *     impl-class="com.clustercontrol.accesscontrol.dao.RoleDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.accesscontrol.dao.RoleDAO
 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl
 */
public abstract class RoleBean implements javax.ejb.EntityBean {
	/** DN */
	public String dn;
	/** Role名 */
	public String cn;
	/** メンバー */
	public ArrayList member;
	/** 説明 */
	public String description;
	/** 新規作成ユーザ */
	public String creatorsName;
	/** 作成日時 */
	public Date createTimestamp;
	/** 最終更新ユーザ */
	public String modifiersName;
	/** 最終更新日時 */
	public Date modifyTimestamp;

	/**
	 * DNを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return DN
	 */
	public String getDn() {
		return dn;
	}
	/**
	 * DNを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dn DN
	 */
	public void setDn(String dn) {
		this.dn = dn;
	}
	/**
	 * Role名を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Role名
	 */
	public String getCn() {
		return cn;
	}
	/**
	 * Role名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param cn Role名
	 */
	public void setCn(String cn) {
		this.cn = cn;
	}
	/**
	 * メンバーを設定します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return メンバー
	 */
	public ArrayList getMember() {
		return member;
	}
	/**
	 * メンバーを返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param member メンバー
	 */
	public void setMember(ArrayList member) {
		this.member = member;
	}
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public Date getCreateTimestamp() {
		return createTimestamp;
	}
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param createTimestamp 作成日時
	 */
	public void setCreateTimestamp(Date createTimestamp) {
		this.createTimestamp = createTimestamp;
	}
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public String getCreatorsName() {
		return creatorsName;
	}
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param creatorsName 新規作成ユーザ
	 */
	public void setCreatorsName(String creatorsName) {
		this.creatorsName = creatorsName;
	}
	/**
	 * 最終更新ユーザを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 最終更新ユーザ
	 */
	public String getModifiersName() {
		return modifiersName;
	}
	/**
	 * 最終更新ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param modifiersName 最終更新ユーザ
	 */
	public void setModifiersName(String modifiersName) {
		this.modifiersName = modifiersName;
	}
	/**
	 * 最終更新日時を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 */
	public Date getModifyTimestamp() {
		return modifyTimestamp;
	}
	/**
	 * 最終更新日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param modifyTimestamp 最終更新日時
	 */
	public void setModifyTimestamp(Date modifyTimestamp) {
		this.modifyTimestamp = modifyTimestamp;
	}
	/**
	 * Roleを作成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param cn Role名
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 */
	public RolePK ejbCreate(String cn) throws javax.ejb.CreateException {
		setCn(cn);
		return null;
	}
	/**
	 * プライマリキーに一致するRoleを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl#findByPrimaryKey(RolePK)
	 */
	public RolePK ejbFindByPrimaryKey(RolePK pk) throws FinderException {
		return null;
	}
	/**
	 * Role名に一致するRoleを検索します。
	 * 
	 * @param cn Role名
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl#findByCn(String)
	 */
	public RolePK ejbFindByCn(String cn) throws FinderException {
		return null;
	}
	/**
	 * 全てのRoleを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException{ 
		return null; 
	}
	/**
	 * Roleのmemberにdnが存在するRoleを検索します。
	 * 
	 * @param dn DN
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl#findByMember(String)
	 */
	public Collection ejbFindByMember(String dn) throws FinderException{ 
		return null; 
	}
	/**
	 * cnが一致し、memberにdnが含まれてるRoleを検索します。
	 * 
	 * @param dn DN
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAOImpl#findByCnAndMenber(String, String)
	 */
	public RolePK ejbFindByCnAndMenber(String cn, String dn) throws FinderException{ 
		return null; 
	}
}
