/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.factory.UserProperty;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ユーザを追加するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、
 * 指定されたユーザ用プロパティの情報を元に、ユーザを追加します。
 * 
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class AddUserProperty {
	
	/**
	 * 
	 * マネージャにユーザを追加します。<BR>
	 * 
	 * マネージャにSessionBean経由でアクセスし、
	 * 指定されたユーザ用プロパティの情報を元に、ユーザを追加します。
	 * 
	 * @param property ユーザ用プロパティ
	 * @return 登録に成功した場合、true
	 * @throws ParseException 
	 * 
	 * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#addUser(com.clustercontrol.bean.Property)
	 */
	public boolean add(Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);
        
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
        boolean result = false;
		try {
			access.addUser(copy);
			result = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (NamingException e) {
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// ユーザIDが重複している場合、エラーダイアログを表示する
				
				//ユーザID取得
		        ArrayList values = PropertyUtil.getPropertyValue(copy, UserProperty.UID);
				String args[] = { (String)values.get(0) };
				
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.monitor.53", args));
	            return result;
			}
		} catch (FinderException e) {
		} catch (ParseException e) {
			// ユーザIDに使用不可な文字列が指定されていた場合、エラーダイアログを表示する
			MessageDialog.openInformation(
					null, 
					Messages.getString("message"),
                    Messages.getString("message.accesscontrol.19"));
			return result;
		}
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.accesscontrol.7"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.accesscontrol.8"));
		}
    	
    	return result;
	}
}