/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.etc.action;

import java.rmi.AccessException;

import javax.naming.CommunicationException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PerspectiveUtil;

/**
 * ログインを行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginAction implements IWorkbenchWindowActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
	/** ワークベンチウィンドウ */
	private IWorkbenchWindow m_window;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {

	}

    /**
     * ワークベンチウィンドウを保持します。
     * 
     * @param window ワークベンチウィンドウ
     * 
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		m_window = window;
	}

	/**
	 * アクセス[ログイン]ダイアログを表示し、ログインを行います。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		
		if(LoginManager.getContextManager().isLogin()){
			// 再ログイン確認ダイアログを生成
            if (!MessageDialog.openQuestion(
            		null, 
					Messages.getString("confirmed"), 
					Messages.getString("message.accesscontrol.17"))) {
            	return;
            }
		}


		//ログインダイアログ表示
        LoginDialog dialog = 
        	new LoginDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());

        //ダイアログ表示
        if (dialog.open() == IDialogConstants.OK_ID) {
        	try {
        		// 再ログインの場合は、パースペクティブを閉じて、ログアウトする
        		if (LoginManager.getContextManager().isLogin()){
            		//HinemosのPerspectiveをすべて閉じる
            		PerspectiveUtil.closeAllHinemosPerspective();
            		//ログアウト
            		LoginManager.getContextManager().logout();
        		}

        		// クライアント側で保持するローカル情報の削除処理
				LocalSession.clearSessionData();
        		
        		//ログイン
				//LoginManager.getContextManager().login(dialog.getUserid(), dialog.getPassword());
        		LoginManager.getContextManager().login(dialog.getUserid(), dialog.getPassword(),dialog.getUrl());
        		
	            // ログイン成功ダイアログを生成
				MessageDialog.openInformation(
						null, 
						Messages.getString("successful"), 
						Messages.getString("message.accesscontrol.5"));
			} catch (CommunicationException e) {
                // 接続失敗ダイアログを生成
            	Status status = new Status(
            			IStatus.ERROR,
            			ClusterControlPlugin.getPluginId(),
            			IStatus.OK,
            			Messages.getString("message.accesscontrol.22"), 
            			e);

            	ErrorDialog.openError(
            			null, 
            			Messages.getString("failed"),
						Messages.getString("message.accesscontrol.21"),
						status);
			} catch (AccessException e) {
                // ログイン失敗ダイアログを生成
            	MessageDialog.openWarning(
            			null, 
            			Messages.getString("failed"), 
            			Messages.getString("message.accesscontrol.6"));
			} catch (Exception e) {
                // 予期せぬエラーダイアログを生成
            	Status status = new Status(
            			IStatus.ERROR,
            			ClusterControlPlugin.getPluginId(),
            			IStatus.OK,
            			Messages.getString("message.accesscontrol.23"), 
            			e);

            	ErrorDialog.openError(
            			null, 
            			Messages.getString("failed"), 
            			Messages.getString("message.accesscontrol.6"),
            			status
            			);
			}
        }
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}
}
