/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.action;

import java.io.IOException;

import com.clustercontrol.bean.FacilityTreeItem;

/**
 * スコープツリーアイテムを取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetFacilityTree {

    /**
     * スコープツリー構造を取得します。<BR>
     * 
     * @return スコープツリー構造
     */
    public FacilityTreeItem getTreeItem(boolean scopeOnly) {
        FacilityTree facilityTree = new FacilityTree();
        try {
			return facilityTree.getTreeItem(scopeOnly).deepCopy();
		} catch (IOException e) {
			// コピー生成に失敗
		} catch (ClassNotFoundException e) {
			// コピー生成に失敗
		}
		return null;
    }
}