package com.clustercontrol.monitor.run.bean;

import java.io.Serializable;

/**
 * 
 * 各監視の結果情報を格納するクラスです。
 * 
 * @version 3.0.0
 * @since 3.0.0
 */
public class MonitorRunResultInfo implements Serializable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 2798625217156631572L;
	
	/** ファシリティID */
	private String m_facilityId;
	
	/** 監視可否 */
	private boolean m_ret; // 不要かも
	
	/** 判定結果 */
	private int m_cheakResult;
	
	/** 重要度 */
	private int m_priority;
	
	/** メッセージ */
	private String m_message;
	
	/** メッセージID */
	private String m_messageId;
	
	/** オリジナルメッセージ */
	private String m_messageOrg;
	
//	/** ログ出力ジョブ実行情報 */
//	private LogOutputJobRunInfo m_jobRunInfo;
	
	/** ノード 監視結果取得時刻 */
	private long m_nodeDate;
	
	/** 通知グループID */
	private String m_notifyGroupId;

	
	/**
	 * 監視結果の重要度を返す
	 * @return 監視結果の重要度
	 */
	public int getCheakResult() {
		return m_cheakResult;
	}

	/**
	 * 監視結果の重要度を設定する
	 * @param 監視結果の重要度
	 */
	public void setCheakResult(int result) {
		m_cheakResult = result;
	}

	/**
	 * ファシリティIDを返す
	 * @return ファシリティID
	 */
	public String getFacilityId() {
		return m_facilityId;
	}

	/**
	 * ファシリティIDを設定する
	 * @param ファシリティID
	 */
	public void setFacilityId(String id) {
		m_facilityId = id;
	}

	/**
	 * メッセージを返す
	 * @return メッセージ
	 */
	public String getMessage() {
		return m_message;
	}

	/**
	 * メッセージを設定する
	 * @param メッセージ
	 */
	public void setMessage(String m_message) {
		this.m_message = m_message;
	}

	/**
	 * メッセージIDを返す
	 * @return メッセージID
	 */
	public String getMessageId() {
		return m_messageId;
	}

	/**
	 * メッセージIDを設定する
	 * @param メッセージID
	 */
	public void setMessageId(String id) {
		m_messageId = id;
	}

	/**
	 * オリジナルメッセージを返す
	 * @return オリジナルメッセージ
	 */
	public String getMessageOrg() {
		return m_messageOrg;
	}

	/**
	 * オリジナルメッセージを設定する
	 * @param オリジナルメッセージ
	 */
	public void setMessageOrg(String messageOrg) {
		m_messageOrg = messageOrg;
	}

	/**
	 * 監視結果取得時刻を返す
	 * @return 監視結果取得時刻
	 */
	public long getNodeDate() {
		return m_nodeDate;
	}

	/**
	 * 監視結果取得時刻を設定する
	 * @param 監視結果取得時刻
	 */
	public void setNodeDate(long date) {
		m_nodeDate = date;
	}

	/**
	 * 監視可否を返す
	 * @return 監視可否
	 */
	public boolean getRet() {
		return m_ret;
	}

	/**
	 * 監視可否を設定する
	 * @param 監視可否
	 */
	public void setRet(boolean ret) {
		this.m_ret = ret;
	}

	/**
	 * 重要度を返す
	 * @return 重要度
	 */
	public int getPriority() {
		return m_priority;
	}

	/**
	 * 重要度を設定する
	 * @param 重要度
	 */
	public void setPriority(int priority) {
		this.m_priority = priority;
	}
	
	/**
	 * 通知グループIDを返す
	 * @return 通知グループID
	 */
	public String getNotifyGroupId() {
		return m_notifyGroupId;
	}
	
	/**
	 * 通知グループIDを設定する
	 * @param notifyGroupId
	 */
	public void setNotifyGroupId(String notifyGroupId) {
		this.m_notifyGroupId = notifyGroupId;
	}
	
}
