/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.message;

import java.io.Serializable;

/**
 * 実行指示情報を保持するクラス<BR>
 * @version 2.0.0
 * @since 1.0.0
 */
public class RunInstructionInfo extends RunInfo implements Serializable {
	private static final long serialVersionUID = -4324117941296918253L;
	
	/** 実行種別 */
    protected String runType;
    /** 入力ファイル */
    protected String inputFile;
    /** ファイルリスト取得パス */
    protected String filePath;
    
    /**
     * 入力ファイルを返します。
     * 
     * @return 入力ファイル
     */
    public String getInputFile() {
    	return inputFile;
    }
    
    /**
     * 入力ファイルを設定します。
     * 
     * @param inputFile 入力ファイル
     */
    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }
    
    /**
     * 実行種別を返します。
     * 
     * @return 実行種別
     */
    public String getRunType() {
        return runType;
    }
    
    /**
     * 実行種別を設定します。
     * 
     * @param runType 実行種別
     */
    public void setRunType(String runType) {
        this.runType = runType;
    }
    
	/**
	 * ファイルリスト取得パスを返します。
	 * 
	 * @return ファイルリスト取得パス
	 */
	public String getFilePath() {
		return filePath;
	}
	
	/**
	 * ファイルリスト取得パスを設定します。
	 * 
	 * @param filePath ファイルリスト取得パス
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
}
