/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.util;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.CommonSendTopic;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;

/**
 * トピックへメッセージを送信するクラス<BR>
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class SendTopic extends CommonSendTopic {
	/** ログ出力のインスタンス */
    protected static Log m_log = LogFactory.getLog( SendTopic.class );
    
    /**
     * コンストラクタ<BR>
     * トピック名を設定します。
     * 初期化処理を行います。
     * 
     * @param topicName
     * @throws NamingException
     * @throws JMSException
     */
    public SendTopic(String topicName) throws NamingException, JMSException{
        super(topicName);
    }
    
    /**
     * 引数で指定されたメッセージをキューへ送信します。
     * 
     * @param info 実行指示情報
     * @throws JMSException
     */
    public void put(RunInstructionInfo info) throws JMSException {
    	TopicPublisher publisher = null;
    	try{
    		publisher = m_session.createPublisher(m_topic);
    		
    		//送信メッセージ作成
    		ObjectMessage message = m_session.createObjectMessage(info);
    		message.setStringProperty("FacilityId", info.getFacilityId());
    		
    		//メッセージ送信
    		publisher.publish(message);
    		m_log.debug("put() topic: SessionId = " + info.getSessionId() + ", JobId = " + info.getJobId() + ", FacilityId = " + info.getFacilityId() + ", CommandType = " + info.getCommandType());
    	}
    	catch(JMSException e){
    		throw e;
    	}
    	finally{
    		try {
    			if (publisher != null)
    				publisher.close();
    		}
    		catch (JMSException e) {
    		}
    		
    		terminate();
    	}
    }
}