/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoData;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 抑制情報を作成するクラスです。
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class AddNotifyInhibition {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( AddNotifyInhibition.class );
	
	/**
	 * 抑制情報を作成します。
	 * <p>
	 * <ol>
	 *  <li>抑制報を作成します。</li>
	 * </ol>
	 * 
	 * @param info 作成対象の抑制情報
	 * @return 作成に成功した場合、<code> true </code>
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 * @throws RemoteException 
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyInfoBean
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoBean
	 */
	@SuppressWarnings("unchecked")
	public boolean add(NotifyActionInhibitionInfoData data) throws CreateException, NamingException{
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		
		try 
		{
			// 抑制情報を挿入
			NotifyActionInhibitionInfoUtil.getLocalHome().create(
					data.getNotifyGroupId(),
					data.getNotifyId(),
					data.getFacilityId(),
					data.getPriority(),
					data.getLastNotifyDate(),
					data.getLastUpdateDate(),
					data.getDupuricationCount(),
					data.getTotalCount()
			);

		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			//String[] args = { relation.getNotifyId() };
			//apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			//String[] args = { relation.getNotifyId() };
			//apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		} 
		
		return true;
	}
	
}
