/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.bean;

import java.io.Serializable;

/**
 * SNMPTRAP監視OID情報のBeanクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorSnmpTrapOidInfo implements Serializable{
	private static final long serialVersionUID = 7129868851549760055L;
	
	protected String monitorId;
	protected String mib;
	protected String trapOid;
	protected int genericId;
	protected int specificId;
	protected String trapName;
	protected int validFlg;
	protected int priority;
	protected String logmsg;
	protected String descr;
	
	public MonitorSnmpTrapOidInfo(){
		
	}

	/**
	 * 説明を取得します。<BR>
	 * @return 説明
	 */
	public String getDescr() {
		return descr;
	}
    /**
     * 説明を設定します。<BR>
     * @param descr
     */
	public void setDescr(String descr) {
		this.descr = descr;
	}
    /**
     * GenericIdを取得します。<BR>
     * @return GenericId
     */
	public int getGenericId() {
		return genericId;
	}
    /**
     * GenericIdを設定します。<BR>
     * @param genericId
     */
	public void setGenericId(int genericId) {
		this.genericId = genericId;
	}

	/**
	 * ログメッセージを取得します。<BR>
	 * @return ログメッセージ
	 */
	public String getLogmsg() {
		return logmsg;
	}
	/**
	 * ログメッセージを設定します。<BR>
	 * @param logmsg
	 */
	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}
    /**
     * MIBを取得します。<BR>
     * @return MIB
     */
	public String getMib() {
		return mib;
	}
    /**
     * MIBを設定します。<BR>
     * @param mib
     */
	public void setMib(String mib) {
		this.mib = mib;
	}
    /**
     * 監視項目IDを取得します。<BR>
     * @return 監視項目ID
     */
	public String getMonitorId() {
		return monitorId;
	}
    /**
     * 監視項目IDを設定します。<BR>
     * @param monitorId
     */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
    /**
     * 監視OIDの重要度を取得します。<BR>
     * @return 監視OIDの重要度
     */
	public int getPriority() {
		return priority;
	}
    /**
     * 監視OIDの重要度を設定します。<BR>
     * @param priority
     */
	public void setPriority(int priority) {
		this.priority = priority;
	}
    /**
     * SpecificIdを取得します。<BR>
     * @return SpecificId
     */
	public int getSpecificId() {
		return specificId;
	}
    /**
     * SpecificIdを設定します。<BR>
     * @param specificId
     */
	public void setSpecificId(int specificId) {
		this.specificId = specificId;
	}
    /**
     * OIDを取得します。<BR>
     * @return OID
     */
	public String getTrapOid() {
		return trapOid;
	}
    /**
     * OIDを設定します。<BR>
     * @param trapOid
     */
	public void setTrapOid(String trapOid) {
		this.trapOid = trapOid;
	}
    /**
     * 有効・無効フラグを取得します。<BR>
     * @return 有効・無効フラグ
     */
    //	FIXME intの意味が現時点で不明。調べて。
	public int getValidFlg() {
		return validFlg;
	}
   /**
    * 有効・無効フラグを設定します。<BR>
    * @param validFlg
    */
	//FIXME intの意味が現時点で不明。調べて。
	public void setValidFlg(int validFlg) {
		this.validFlg = validFlg;
	}
    /**
     * トラップ名を取得します。<BR>
     * @return
     */
	public String getTrapName() {
		return trapName;
	}
    /**
     * トラップ名を設定します。<BR>
     * @param trapName
     */
	public void setTrapName(String trapName) {
		this.trapName = trapName;
	}
}
