/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.vm.ejb.entity;

import javax.ejb.EntityBean;

/**
 * cc_vm_method_mst情報を管理するEntity Bean <BR>
 * @ejb.bean name="VmMethodMst"
 *           jndi-name="VmMethodMst"
 *           type="CMP"
 *           schema="VmMethodMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="vmSolutionId","procType"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_vm_method_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM VmMethodMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.vm.ejb.entity.VmMethodMstPK"
 *   
 */
public abstract class VmMethodMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public VmMethodMstPK ejbCreate(
			String vmSolutionId,
			String procType,
			String className
		) throws javax.ejb.CreateException {
		
		this.setVmSolutionId(vmSolutionId);
		this.setProcType(procType);
		this.setClassName(className);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param vmSolutionId 仮想化ソリューション種別
	 * @param procType 仮想化処理種別
	 * @param className クラス名
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String vmSolutionId,
			String procType,
			String className
		) throws javax.ejb.CreateException {
	}
	
	
	
	
	
	/**
	 * 仮想化ソリューション種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_solution_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="true"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the vmSolutionId.
	 */
	public abstract String getVmSolutionId();

	/**
	 * 仮想化ソリューション種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param vmSolutionId The vmSolutionId to set.
	 */
	public abstract void setVmSolutionId(String vmSolutionId);

	
	
	
	/**
	 * 仮想化処理種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="proc_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="true"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the procType.
	 */
	public abstract String getProcType();

	/**
	 * 仮想化処理種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param procType The procType to set.
	 */
	public abstract void setProcType(String procType);

	
	
	
	/**
	 * クラス名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="class_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="true"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the className.
	 */
	public abstract String getClassName();

	/**
	 * クラス名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param className The className to set.
	 */
	public abstract void setClassName(String className);

}
