/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.vm.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;


/**
 * VMアクションログのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="VmOperationDetail"
 *           jndi-name="VmOperationDetail"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.vm.dao.VmOperationDetailDAO"
 * impl-class="com.clustercontrol.vm.dao.VmOperationDetailDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 */

public abstract class VmOperationDetailBean implements EntityBean {
	
	/*
	 *     session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_type character varying(64),
    command_id character varying(64),

    status smallint,
    start_date timestamp without time zone,

    end_status smallint,
    end_date timestamp without time zone,
    end_value smallint,
    message text
	 */
	
	
	/** セッションID */
    protected String sessionId;
    /** ファシリティID */
    protected String facilityId;
    /** ファシリティ名 */
    protected String scopeText;
    /** ノード種別 */
    protected String nodeType;
    /** コマンドID */
    protected String commandId;
    /** 実行状態 */
    protected Short status;
    /** 開始・再開日時 */
    protected Date startDate;
    /** 実行状態 */
    protected Short endStatus;
    /** 終了・中断日時 */
    protected Date endDate;
    /** 戻り値 */
    protected Integer endValue;
    /** メッセージ */
    protected String message;
    
    
    /**
     * VMアクションログを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param sessionId
     * @param facilityId
     * @param scopeText
     * @param nodeType
     * @param commandId
     * @param status
     * @param startDate
     * @param endStatus
     * @param endDate
     * @param endValue
     * @param message
     * @return
     * @throws javax.ejb.CreateException
     */
	public VmOperationDetailPK ejbCreate(
			String sessionId,
			String facilityId,
			String scopeText,
			String nodeType,
			String commandId,
			Short status,
			Date startDate,
			Short endStatus,
			Date endDate,
			Integer endValue,
			String message
			) throws javax.ejb.CreateException {

		this.sessionId = sessionId;
		this.facilityId = facilityId;
		this.scopeText = scopeText;
		this.nodeType = nodeType;
		this.commandId = commandId;
		this.status = status;
		this.startDate = startDate;
		this.endStatus = endStatus;
		this.endDate = endDate;
		this.endValue = endValue;
		this.message = message;
		
		return null;
	}
	
	
	/**
	 * 全てのVMアクションログを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するVMアクションログを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 */
	public VmOperationDetailPK ejbFindByPrimaryKey(VmOperationDetailPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDに一致するVMアクションログを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 */
	public Collection ejbFindBySessionId(String sessionId) throws FinderException {
		return null;
	}

	
	/**
	 * VMアクションログの履歴を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 */
	public Collection ejbFindHistory(int history) throws FinderException {
		return null;
	}


	
	
	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param sessionId セッションID
	 */
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * ファシリティIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public String getFacilityId() {
		return facilityId;
	}

	/**
	 * ファシリティIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

    /**
     * ファシリティ名を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return ファシリティ名
     * 
     */
	public String getScopeText() {
		return scopeText;
	}

    /**
     * ファシリティ名を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param scopeText ファシリティ名
     * 
     */
	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}


    /**
     * ノード種別を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return ノード種別
     * 
     */
	public String getNodeType() {
		return nodeType;
	}

    /**
     * ノード種別を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param nodeType ノード種別
     * 
     */
	public void setNodeType(String nodeType) {
		this.nodeType = nodeType;
	}


    /**
     * コマンドIDを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return コマンドID
     * 
     */
	public String getCommandId() {
		return commandId;
	}

    /**
     * コマンドIDを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param commandId コマンドID
     * 
     */
	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}


    /**
     * 実行状態を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 実行状態
     * 
     */
	public Short getStatus() {
		return status;
	}

    /**
     * 実行状態を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param status 実行状態
     * 
     */
	public void setStatus(Short status) {
		this.status = status;
	}

    /**
     * 開始日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 開始日時
     * 
     */
	public Date getStartDate() {
		return startDate;
	}

    /**
     * 開始日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param startDate 開始日時
     * 
     */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

    /**
     * 終了状態を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了状態
     * 
     */
	public Short getEndStatus() {
		return endStatus;
	}

    /**
     * 終了状態を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param endStatus 終了状態
     * 
     */
	public void setEndStatus(Short endStatus) {
		this.endStatus = endStatus;
	}


    /**
     * 終了日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了日時
     * 
     */
	public Date getEndDate() {
		return endDate;
	}


    /**
     * 終了日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param endDate 終了日時
     * 
     */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

    /**
     * 終了値を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了日時
     * 
     */
	public Integer getEndValue() {
		return endValue;
	}


    /**
     * 終了値を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param endValue 終了値
     * 
     */
	public void setEndValue(Integer endValue) {
		this.endValue = endValue;
	}

    /**
     * メッセージを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return メッセージ
     * 
     */
	public String getMessage() {
		return message;
	}

    /**
     * メッセージを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param message メッセージ
     * 
     */
	public void setMessage(String message) {
		this.message = message;
	}

	
	
	
	
	
	
}
