/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.notify.mail.action.GetMailTemplate;
import com.clustercontrol.notify.mail.action.GetMailTemplateListTableDefine;
import com.clustercontrol.notify.mail.bean.MailTemplateTableDefine;
;

/**
 * メールテンプレート一覧コンポジットクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class MailTemplateListComposite extends Composite {

    /** テーブルビューアー。 */
    private CommonTableViewer tableViewer = null;

    /**
	 * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 * 
	 * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize()
	 */
    public MailTemplateListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    /**
     * コンポジットを配置します。
     * 
     * @see com.clustercontrol.notify.action.GetMailTemplateListTableDefine#get()
     * @see #update()
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // テーブルビューアの作成
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMailTemplateListTableDefine.get(),
        		MailTemplateTableDefine.SORT_COLUMN_INDEX,
        		MailTemplateTableDefine.SORT_ORDER);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        this.update();
    }

    /**
     * このコンポジットが利用するテーブルビューアーを返します。
     * 
     * @return テーブルビューアー
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * コンポジットを更新します。<BR>
     * メールテンプレート一覧情報を取得し、テーブルビューアーにセットします。
	 * 
	 * @see com.clustercontrol.notify.mail.action.GetMailTemplate#getMailTemplateList()
     */
    public void update() {
        // データ取得
    	ArrayList list = new GetMailTemplate().getMailTemplateList();
    	
    	if(list == null)
    		list = new ArrayList();
    	 
        // テーブル更新
        this.tableViewer.setInput(list);
    }
}