/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 履歴フィルタ用プロパティ取得するクライアント側アクションクラス<BR>
 * 
 * サーバから履歴フィルタ用プロパティを取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryFilterProperty {

    /**
     * 履歴フィルタ用プロパティを取得します。<BR>
     * 
     * @return 履歴フィルタ用プロパティ
     * @since 1.0.0
     */
    public Property getProperty() {
        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        Property property = null;
        try {
            property = collectiveRun.getHistoryFilterProperty(Locale
                    .getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        	//TODO FinderException 未実装
		} catch (NamingException e) {
			//TODO NamingException 未実装
		}
        return property;
    }
}