/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.bean;

import com.clustercontrol.util.Messages;

/**
 * 一括制御機能における、種別定数クラスです。<BR>
 * 種別IDと種別文字列を変換する際に使用します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ItemConstant {
    /** ツリーのトップ */
    public static final int TYPE_COMPOSITE = -1;
    
    /** コマンドツリーのトップ */
    public static final int TYPE_COMMADN_COMPOSITE = -2;
    
    /** パラメータツリーのトップ */
    public static final int TYPE_PARAMETER_COMPOSITE = -3;
    
    /** 種別 */
    public static final int TYPE_TYPE = 0;

    /** コマンド */
    public static final int TYPE_COMMAND = 1;

    /** コマンドパラメータ */
    public static final int TYPE_COMMAND_PARAMETER = 2;
    
    /** パラメータ */
    public static final int TYPE_PARAMETER = 3;
    
    /** 選択肢 */
    public static final int TYPE_SELECT_ITEM = 4;

    /** ツリーのトップ */
    public static final String STRING_COMPOSITE = "";

    /** コマンドツリーのトップ */
    public static final String STRING_COMMADN_COMPOSITE = Messages.getString("command");
    
    /** パラメータツリーのトップ */
    public static final String STRING_PARAMETER_COMPOSITE = Messages.getString("parameter");
    
    /** 種別 */
    public static final String STRING_TYPE = Messages.getString("type");

    /** コマンド */
    public static final String STRING_COMMAND = Messages.getString("command");

    /** コマンドパラメータ */
    public static final String STRING_COMMAND_PARAMETER = Messages.getString("parameter");

    /** パラメータ */
    public static final String STRING_PARAMETER = Messages.getString("parameter");

    /** 選択肢 */
    public static final String STRING_SELECT_ITEM = Messages.getString("select.item");
    
    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_COMPOSITE) {
            return STRING_COMPOSITE;
        } else if (type == TYPE_COMMADN_COMPOSITE) {
            return STRING_COMMADN_COMPOSITE;
        } else if (type == TYPE_PARAMETER_COMPOSITE) {
            return STRING_PARAMETER_COMPOSITE;
        } else if (type == TYPE_TYPE) {
            return STRING_TYPE;
        } else if (type == TYPE_COMMAND) {
            return STRING_COMMAND;
        } else if (type == TYPE_COMMAND_PARAMETER) {
            return STRING_COMMAND_PARAMETER;
        } else if (type == TYPE_PARAMETER) {
            return STRING_PARAMETER;
        } else if (type == TYPE_SELECT_ITEM) {
            return STRING_SELECT_ITEM;
        }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_COMPOSITE)) {
            return TYPE_COMPOSITE;
        } else if (string.equals(STRING_COMMADN_COMPOSITE)) {
            return TYPE_COMMADN_COMPOSITE;
        } else if (string.equals(STRING_PARAMETER_COMPOSITE)) {
            return TYPE_PARAMETER_COMPOSITE;
        } else if (string.equals(STRING_TYPE)) {
            return TYPE_TYPE;
        } else if (string.equals(STRING_COMMAND)) {
            return TYPE_COMMAND;
        } else if (string.equals(STRING_COMMAND_PARAMETER)) {
            return TYPE_COMMAND_PARAMETER;
        } else if (string.equals(STRING_PARAMETER)) {
            return TYPE_PARAMETER;
        } else if (string.equals(STRING_SELECT_ITEM)) {
            return TYPE_SELECT_ITEM;
        }
        return -1;
    }
}