/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.ejb.entity;

import javax.ejb.EntityBean;

/**
 * エージェント監視の設定情報EntityBean
 * 
 * @ejb.bean name="MonitorAgentInfo"
 *           jndi-name="MonitorAgentInfo"
 *           type="CMP"
 *           schema="MonitorAgentInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Instance Per Transaction CMP 2.x EntityBean"
 *  
 *  @jboss.optimistic-locking
 *     modified-strategy="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_agent_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorAgentInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK"
 *   
 */
public abstract class MonitorAgentInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorAgentInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			Integer checkJobAgent, 
			Integer checkLogAgent
	) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setCheckJobAgent(checkJobAgent);
		this.setCheckLogAgent(checkLogAgent);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="check_job_agent"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the checkJobAgent.
	 */
	public abstract Integer getCheckJobAgent();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param checkJobAgent The checkJobAgent to set.
	 */
	public abstract void setCheckJobAgent(Integer checkJobAgent);
	
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="check_log_agent"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the checkLogAgent.
	 */
	public abstract Integer getCheckLogAgent();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param checkLogAgent The checkLogAgent to set.
	 */
	public abstract void setCheckLogAgent(Integer checkLogAgent);
	
}
