/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.util.Date;

import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.maintenance.util.SendEvent;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.util.Messages;


/**
 * 監視管理に通知するクラスです。
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class Notice {
	/** ログ出力のインスタンス */
    protected static Log m_log = LogFactory.getLog( Notice.class );
    
	/**
	 * メンテナンスIDからメンテナンス通知情報を取得し、<BR>
	 * メンテナンス通知情報と終了状態を基に、ログ出力情報作成し、監視管理に通知します。
	 * 
	 * @param sessionId セッションID
	 * @param maintenanceId メンテナンスID
	 * @param type 終了状態
	 * @param result メンテナンス実行結果
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 * @see com.clustercontrol.bean.JobConstant
	 * @see com.clustercontrol.monitor.message.LogOutputNotifyInfo
	 * @see com.clustercontrol.jobmanagement.util.SendEvent#put(LogOutputNotifyInfo)
	 */
	public void notify(String maintenanceId, Integer type, int result) throws FinderException, NamingException {
	    m_log.debug("notify() : maintenanceId=" + maintenanceId + ", type=" + type);
	    
	    MaintenanceInfoLocal info = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
	    
	    //MaintenanceInfoを取得する
	    
	    if(info.getNotifyGroupId() != null && info.getNotifyGroupId().length() > 0){
	        //通知する

	        //通知情報作成
	    	OutputNotifyGroupInfo notice = new OutputNotifyGroupInfo();
	    		    	
	        //プラグインID
	        notice.setPluginId("MAINTENANCE");
	        //アプリケーション
	        notice.setApplication(info.getApplication());
	        //監視項目ID
	        notice.setMonitorId(maintenanceId);
	        
	        //メンテナンス機能では該当する値なし
	        notice.setFacilityId(FacilityTreeAttributeConstant.INTERNAL_SCOPE);
	        notice.setScopeText(FacilityTreeAttributeConstant.INTERNAL_SCOPE_TEXT);
	        
	        //メッセージID、メッセージ、オリジナルメッセージ
	        if(type.intValue() == PriorityConstant.TYPE_INFO){
	            notice.setMessageId("001");
	            String[] args1 = {maintenanceId};
	            notice.setMessage(Messages.getString("message.maintenance.12", args1));
	        }
	        else if(type.intValue() == PriorityConstant.TYPE_CRITICAL){
	            notice.setMessageId("002");
	            String[] args1 = {maintenanceId};
	            notice.setMessage(Messages.getString("message.maintenance.13", args1));
	        }
            notice.setMessageOrg(info.getType_id() + " : " + result + " records");
	        
	        //重要度
	        notice.setPriority(type.intValue());
	        //発生日時
	        notice.setGenerationDate(new Date());
	        //通知グループID
	        notice.setNotifyGroupId(info.getNotifyGroupId());
	        
	        try {
	            //イベント通知
                new SendEvent().put(notice);
            } catch (JMSException e) {
            	//TODO JMSException 未実装
            } catch (NamingException e) {
            	//TODO NamingException 未実装
            }
	    }
	}
//	
//	/**
//	 * 遅延通知
//	 * 
//	 * @param sessionId
//	 * @param jobId
//	 * @param startDelay
//	 * @throws FinderException
//	 * @throws NamingException
//	 */
//	/**
//	 * セッションIDとジョブIDからジョブ通知情報を取得し、<BR>
//	 * ジョブ通知情報と開始遅延フラグを基に、ログ出力情報作成し、監視管理に通知します。
//	 * 
//	 * @param sessionId セッションID
//	 * @param jobId ジョブID
//	 * @param startDelay 開始遅延フラグ（true：開始遅延、false：終了遅延）
//	 * @throws FinderException
//	 * @throws NamingException
//	 * 
//	 * @see com.clustercontrol.bean.EndStatusConstant
//	 * @see com.clustercontrol.bean.JobConstant
//	 * @see com.clustercontrol.monitor.message.LogOutputNotifyInfo
//	 * @see com.clustercontrol.jobmanagement.util.SendEvent#put(LogOutputNotifyInfo)
//	 */
//	public void delayNotify(String sessionId, String jobId, boolean startDelay) throws FinderException, NamingException {
//	    m_log.debug("delayNotify() : sessionId=" + sessionId + ", jobId=" + jobId + ", startDelay=" + startDelay);
//	    
//	    //セッションIDとジョブIDから、セッションジョブを取得
//	    JobSessionJobLocal sessionJob = 
//	        JobSessionJobUtil.getLocalHome().findByPrimaryKey(
//	                new JobSessionJobPK(sessionId, jobId));
//	    
//	    JobInfoLocal job = sessionJob.getJobInfo();
//	    JobStartInfoLocal start = job.getJobStartInfo();
//	    
//	    //セッションID、ジョブID、通知タイプ(終了状態+開始)から、通知情報を取得
//	    JobNoticeInfoLocal notice = 
//	        JobNoticeInfoUtil.getLocalHome().findByPrimaryKey(
//	                new JobNoticeInfoPK(sessionId, jobId, Integer.valueOf(EndStatusConstant.TYPE_NORMAL)));
//	    
//	    
//	    if(notice.getNotify_id() != null && notice.getNotify_id().length() > 0){
//	        //通知する
//
//	        //通知情報作成
//	    	LogOutputNotifyInfo info = new LogOutputNotifyInfo();
//	        //プラグインID
//	        info.setPluginId("JOB");
//	        //アプリケーション
//	        info.setApplication(Messages.getString("job.management"));
//	        //監視項目ID
//	        info.setMonitorId(sessionId);
//	        
//	        //メッセージID、メッセージ、オリジナルメッセージ
//	        StringBuilder message = new StringBuilder();
//	        if(startDelay){
//	        	info.setMessageId("101");
//	        	String[] args1 = {jobId};
//            	message.append(Messages.getString("message.job.55", args1));
//            	
//            	//操作
//            	if(start.getStart_delay_operation().intValue() == YesNoConstant.TYPE_YES){
//            		int type = start.getStart_delay_operation_type().intValue();
//            		
//            		String[] args2 = {OperationConstant.typeToString(type)};
//    	            message.append(" " + Messages.getString("message.job.57", args2));
//            		
//            		if(type == OperationConstant.TYPE_STOP_SKIP){
//        	            info.setMessageId("102");
//        	            String[] args3 = {start.getStart_delay_operation_end_value().toString()};
//        	            message.append(" " + Messages.getString("message.job.58", args3));
//        	        }
//        	        else if(type == OperationConstant.TYPE_STOP_WAIT){
//        	            info.setMessageId("103");
//        	        }
//            	}
//            	info.setMessage(message.toString());
//	        }
//	        else{
//	        	info.setMessageId("201");
//	        	String[] args1 = {jobId};
//            	message.append(Messages.getString("message.job.56", args1));
//            	
//            	//操作
//            	if(start.getEnd_delay_operation().intValue() == YesNoConstant.TYPE_YES){
//            		int type = start.getEnd_delay_operation_type().intValue();
//            		
//            		String[] args2 = {OperationConstant.typeToString(type)};
//    	            message.append(" " + Messages.getString("message.job.57", args2));
//            		
//            		if(type == OperationConstant.TYPE_STOP_AT_ONCE){
//        	            info.setMessageId("202");
//        	        }
//        	        else if(type == OperationConstant.TYPE_STOP_SUSPEND){
//        	            info.setMessageId("203");
//        	        }
//            	}
//            	info.setMessage(message.toString());
//	        }
//	        
//	        if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
//	            JobCommandInfoLocal command = job.getJobCommandInfo();
//	            //ファシリティID
//	            info.setFacilityId(command.getFacility_id());
//	            //スコープ
//	        	info.setScopeText(sessionJob.getScope_text());
//	        }
//	        else{
//	            //ファシリティID
//	            info.setFacilityId("");
//	            //スコープ
//	        	info.setScopeText("");
//	        }
//	        //重要度
//	        if(startDelay)
//	        	info.setPriority(start.getStart_delay_notify_priority().intValue());
//	        else
//	        	info.setPriority(start.getEnd_delay_notify_priority().intValue());
//	        //発生日時
//	        info.setGenerationDate(new Date());
//	        //通知ID
//	        info.setNotifyId(notice.getNotify_id());
//	        
//	        try {
//	            //イベント通知
//                new SendEvent().put(info);
//            } catch (JMSException e) {
//            	m_log.error(e);
//            } catch (NamingException e) {
//            	m_log.error(e);
//            }
//	    }
//	}
}
