/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;

/**
 * 監視情報のCMP Entity Bean
 * 
 * @ejb.bean name="MonitorInfo"
 *           jndi-name="MonitorInfo"
 *           type="CMP"
 *           schema="MonitorInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Instance Per Transaction CMP 2.x EntityBean"
 * 
 * @jboss.optimistic-locking
 *    modified-strategy="true"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="cc_monitor_info" 
 *    
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAll(java.lang.String monitorTypeId)"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a WHERE a.monitorTypeId = ?1"
 *    signature="java.util.Collection findAll(java.lang.String monitorTypeId)"
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a WHERE a.facilityId = ?1"  
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"  
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK" 
 *           
 */
public abstract class MonitorInfoBean implements EntityBean {
	
	/**
	 * 監視情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param monitorType 監視種別
	 * @param description 説明
	 * @param facilityId ファシリティID
	 * @param runInterval 実行間隔
	 * @param timeout タイムアウト
	 * @param calendarId カレンダID
	 * @param monitorBlock 監視単位
	 * @param determinationId 判定ID（未使用）
	 * @param failurePriority 値取得の失敗時の重要度
	 * @param application アプリケーション
     * @param failureMessageId 値取得の失敗時のメッセージID（未使用）
	 * @param failureMessage 値取得の失敗時のメッセージ（未使用）
	 * @param notifyGroupId 通知グループID
	 * @param updateDate 最終変更日時
	 * @param regUser 新規作成ユーザ
	 * @param updateUser 最終変更ユーザ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public MonitorInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer monitorType, 
			String description, 
			String facilityId, 
			Integer runInterval, 
			Integer timeout,
			String calendarId, 
			Integer monitorBlock, 
			String determinationId, 
			Integer failurePriority,
			String application, 
			String failureMessageId, 
			String failureMessage,
			String notifyGroupId,
			Timestamp regDate,  
			Timestamp updateDate, 
			String regUser, 
			String updateUser
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setMonitorType(monitorType);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setRunInterval(runInterval);
		this.setTimeout(timeout);
		this.setCalendarId(calendarId);
		this.setMonitorBlock(monitorBlock);
		this.setDeterminationId(determinationId);
		this.setFailurePriority(failurePriority);
		this.setApplication(application);
		this.setFailureMessageId(failureMessageId);
		this.setFailureMessage(failureMessage);
		this.setNotifyGroupId(notifyGroupId);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);
		
		return null;
	}
	
	
	/**
	 * 通知グループIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public abstract String getNotifyGroupId();

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failureMessage 通知グループID
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);
	
	
	/**
	 * 値取得の失敗時のメッセージを返します（未使用）。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 値取得の失敗時のメッセージ
	 */
	public abstract String getFailureMessage();

	/**
	 * 値取得の失敗時のメッセージを設定します（未使用）。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failureMessage 値取得の失敗時のメッセージ
	 */
	public abstract void setFailureMessage(String failureMessage);

	/**
	 * 値取得の失敗時のメッセージIDを返します（未使用）。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 値取得の失敗時のメッセージID
	 */
	public abstract String getFailureMessageId();

	/**
	 * 値取得の失敗時のメッセージIDを設定します（未使用）。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failureMessageId 値取得の失敗時のメッセージID
	 */
	public abstract void setFailureMessageId(String failureMessageId);
	

	/**
	 * アプリケーションを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return アプリケーション
	 */
	public abstract String getApplication();

	/**
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param application アプリケーション
	 */
	public abstract void setApplication(String application);

	/**
	 * カレンダIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public abstract String getCalendarId();

	/**
	 * カレンダIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendarId カレンダID
	 */
	public abstract void setCalendarId(String calendarId);

	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();

	/**
	 * 説明を設定します（未使用）。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);

	/**
	 * 判定IDを返します（未使用）。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="determination_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 判定ID
	 */
	public abstract String getDeterminationId();

	/**
	 * 判定IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param determinationId 判定ID
	 */
	public abstract void setDeterminationId(String determinationId);

	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);
	
	
	/**
	 * 値取得の失敗時の重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getFailurePriority();

	/**
	 * 値取得の失敗時の重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failurePriority 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setFailurePriority(Integer failurePriority);
		

	/**
	 * 監視単位を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_block"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視単位
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	public abstract Integer getMonitorBlock();

	/**
	 * 監視単位を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorBlock 監視単位
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	public abstract void setMonitorBlock(Integer monitorBlock);

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 監視種別を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public abstract Integer getMonitorType();

	/**
	 * 監視種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorType 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public abstract void setMonitorType(Integer monitorType);
	
	/**
	 * 監視対象IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視対象ID
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視対象IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return regDate 作成日時
	 */
	public abstract Timestamp getRegDate();

	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);	

	/**
	 * 実行間隔を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 実行間隔
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public abstract Integer getRunInterval();

	/**
	 * 実行間隔を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param runInterval 実行間隔
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public abstract void setRunInterval(Integer runInterval);
	
	/**
	 * タイムアウトを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return タイムアウト
	 */
	public abstract Integer getTimeout();

	/**
	 * タイムアウトを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param timeout タイムアウト
	 */
	public abstract void setTimeout(Integer timeout);

	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return updateDate 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ 
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
	/**
	 * 真偽値監視判定情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorTruthValueInfo"
	 * role-name="MonitorInfo-MonitorTruthValueInfo(single)"
	 *  
	 * @return 真偽値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 */
	public abstract Collection getMonitorTruthValueInfo();
	
	/**
	 * 真偽値監視判定情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 真偽値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 */
	public abstract void setMonitorTruthValueInfo(Collection collection);
	
	/**
	 * 数値監視判定情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorNumericValueInfo"
	 * role-name="MonitorInfo-MonitorNumericValueInfo(single)"
	 *  
	 * @return 数値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	public abstract Collection getMonitorNumericValueInfo();
	
	/**
	 * 数値監視判定情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 数値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	public abstract void setMonitorNumericValueInfo(Collection collection);
	
	/**
	 * 文字列監視判定情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorStringValueInfo"
	 * role-name="MonitorInfo-MonitorStringValueInfo(single)"
	 *  
	 * @return 文字列監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	public abstract Collection getMonitorStringValueInfo();
	
	/**
	 * 文字列監視判定情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 文字列監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	public abstract void setMonitorStringValueInfo(Collection collection);
	
	
}
