/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;



/**
 * 監視情報のCMP Entity Bean
 * 
 * @ejb.bean name="NotifyRelationInfo"
 *           jndi-name="NotifyRelationInfo"
 *           type="CMP"
 *           schema="NotifyRelationInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="notifyGroupId","notifyId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="cc_notify_relation_info" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyRelationInfo as a"  
 *    signature="java.util.Collection findAll()" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyRelationInfo as a WHERE a.notifyGroupId = ?1 order by a.notifyId" 
 *    signature="java.util.Collection findByNotifyGroupId(java.lang.String notifyGroupId)"
 *   
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyRelationInfo as a WHERE a.notifyId = ?1 order by a.notifyGroupId" 
 *    signature="java.util.Collection findByNotifyId(java.lang.String notifyId)"
 *
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyRelationInfoPK" 
 *           
 */
public abstract class NotifyRelationInfoBean implements EntityBean {
	
	/**
	 * 監視情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param notifyGroupId 通知グループID
	 * @param notifyId 通知ID
	 * @param notifyType 通知タイプ
	 * @param notifyFlg  通知フラグ
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public NotifyRelationInfoPK ejbCreate(
			String notifyGroupId, 
			String notifyId, 
			Integer notifyType, 
			Integer notifyFlg
			) throws javax.ejb.CreateException {

		this.setNotifyGroupId(notifyGroupId);
		this.setNotifyId(notifyId);
		this.setNotifyType(notifyType);
		this.setNotifyFlg(notifyFlg);		
		return null;
	}
	
	/**
	 * 通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知フラグ
	 * 
	 */
	public abstract Integer getNotifyFlg();

	/**
	 * 通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyFlg 通知フラグ
	 * 
	 */
	public abstract void setNotifyFlg(Integer notifyFlg);

	/**
	 * 通知グループIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public abstract String getNotifyGroupId();

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 通知グループID
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);
	
	/**
	 * 監視種別を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public abstract Integer getNotifyType();

	/**
	 * 監視種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyType 監視種別
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyTypeConstant
	 */
	public abstract void setNotifyType(Integer notifyType);
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();

	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);


    
	
}
