/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/


package com.clustercontrol.performance.bean;

import java.io.Serializable;
import java.util.List;

import com.clustercontrol.performance.bean.CollectorRunStatus;
import com.clustercontrol.performance.bean.DeviceDataSet;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;

/**
 * 収集設定及び収集のプロパティをセットで扱うためのDTOクラス
 * 
 * このクラスは実績情報収集設定を行う際の収集全般、収集項目、閾値監視設定の
 * 各オブジェクを束ねることを目的としたクラスです。
 * またこのオブジェクトはプロパティ表示の際にも用いられ、収集時点を再現するために
 * 必要となる収集時点のデバイス情報も含んでいます。
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorProperty implements Serializable {
	private static final long serialVersionUID = 3977840669193117479L;

	private RecordCollectorData m_collectorData;
	private List<CollectorItemInfo> m_itemList;
	private DeviceDataSet m_deviceSet;
	
	/**
	 * 収集設定（プロパティ）情報を取得します。
	 * @return collectorData 収集設定（プロパティ）情報
	 */
	public RecordCollectorData getCollectorData() {
		return m_collectorData;
	}
	/**
	 * 収集設定（プロパティ）情報を設定します。
	 *  @param collectorData 収集設定（プロパティ）情報
	 */
	public void setCollectorData(RecordCollectorData collectorData) {
		this.m_collectorData = collectorData;
	}
	/**
	 * 収集項目設定（プロパティ）のリストを取得します。
	 * @return itemList 収集項目のリスト
	 */
	public List<CollectorItemInfo> getItemList() {
		return m_itemList;
	}
	/**
	 * 収集項目のリストを設定します。
	 * @param itemList 収集項目のリスト
	 */
	public void setItemList(List<CollectorItemInfo> itemList) {
		this.m_itemList = itemList;
	}

	/**
	 * デバイス情報のセットを取得します。
	 * @return deviceSet デバイス情報のセット
	 */
	public DeviceDataSet getDeviceSet() {
		return m_deviceSet;
	}
	
	/**
	 * デバイス情報のセットを設定します。
	 * @param deviceSet デバイス情報のセット
	 */
	public void setDeviceSet(DeviceDataSet deviceSet) {
		this.m_deviceSet = deviceSet;
	}
	
	/**
	 * 
	 * 収集中であるかどうかのフラグを取得します。
	 * @return true 収集中　false　収集終了
	 */
	public boolean isRunnig(){
		return (this.m_collectorData.getStatus() == CollectorRunStatus.RUNNING);
	}
	
	/**
	 * 収集終了しているかどうかのフラグを取得します。
	 * @return true 収集終了　false　収集中
	 */
	public boolean isFinished(){
		return (this.m_collectorData.getStatus() == CollectorRunStatus.FINISHED);
	}

//	// FIXME 監視設定はプロパティからはずす予定
//	/**
//	 * 閾値監視設定（プロパティ）のリストを取得します。
//	 * @return monitorList 閾値監視設定のリスト
//	 */
//	public ArrayList getMonitorList() {
//		return null;
//	}
//	/**
//	 * 閾値監視設定のリストを設定します。
//	 * @param monitorList 閾値監視設定のリスト
//	 */
//	public void setMonitorList(ArrayList monitorList) {
//	}
}
