/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.bean;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;

/**
 * ping監視設定情報のBeanクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class MonitorPingInfo extends MonitorCheckInfo
{
	
	/** 実行回数 */
	protected java.lang.Integer runCount = Integer.valueOf(PingRunCountConstant.TYPE_COUNT_01);
	/** 実行間隔（秒） */
	protected java.lang.Integer runInterval = Integer.valueOf(PingRunIntervalConstant.TYPE_SEC_01);
	/** タイムアウト（ミリ秒） */
	protected java.lang.Integer timeout = 1000;


   public MonitorPingInfo()
   {
   }

	/**
	 * 実行回数（一回のチェックで何個パケットを投げるか？）を取得します。
	 *
	 */
   public java.lang.Integer getRunCount()
   {
      return this.runCount;
   }
   /**
    * 実行回数（一回のチェックで何個パケットを投げるか？）をセットします。
    * @param runCount
    */
   public void setRunCount( java.lang.Integer runCount )
   {
      this.runCount = runCount;
   }

   /**
    * 実行間隔（秒）を取得します。
    * 
    */
   public java.lang.Integer getRunInterval()
   {
      return this.runInterval;
   }
   /**
    * 実行間隔（秒）をセットします。
    * @param runInterval
    */
   public void setRunInterval( java.lang.Integer runInterval )
   {
      this.runInterval = runInterval;
   }
   /**
    * タイムアウト（ミリ秒）を取得します。
    * @return
    */
   public java.lang.Integer getTimeout()
   {
      return this.timeout;
   }
   /**
    * タイムアウト（ミリ秒）をセットします。
    * @param timeout
    */
   public void setTimeout( java.lang.Integer timeout )
   {
      this.timeout = timeout;
   }
}
