/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.bean;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * SNMPTRAP監視設定情報のBeanクラス<BR>
 * 
 *  監視側（設定側でない）で利用するDTOクラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapFacilityInfo implements Serializable {
	
	private static final long serialVersionUID = 8865430590959491257L;

	private String m_monitorId;
	private String m_facilityId;
	private String m_communityName;
	private int m_checkMode;
	private String calendarId;
	
	/**トラップを受け付けるfacilityID(ノード？)のリスト */
	
	ArrayList<String> m_facilityIdList;
	
	/** トラップを受け付けるOIDのリスト */
	
	ArrayList<SnmpTrapOidInfo> m_oidList;
	
	/**
	 * コンストラクタ
	 *
	 */
	public SnmpTrapFacilityInfo() {
	}
	/**
	 * コンストラクタ
	 * @param monitorId
	 * @param facilityId
	 * @param communityName
	 * @param facilityIdList
	 * @param oidList
	 */
	public SnmpTrapFacilityInfo(String monitorId, String facilityId, String communityName, ArrayList<String> facilityIdList, ArrayList<SnmpTrapOidInfo> oidList) {
		this.m_monitorId = monitorId;
		this.m_facilityId = facilityId;
		this.m_communityName = communityName;
		this.m_facilityIdList = facilityIdList;
		this.m_oidList = oidList;
	}
	/**
	 * コミュニティ名を取得します。<BR>
	 * @return コミュニティ名
	 */
	public String getCommunityName() {
		return m_communityName;
	}
	/**
	 * コミュニティ名を設定します。<BR>
	 * @param communityName
	 */
	public void setCommunityName(String communityName) {
		this.m_communityName = communityName;
	}
	/**
	 * ファシリティIDを取得します。<BR>
	 * @return ファシリティID
	 */
	public String getFacilityId() {
		return m_facilityId;
	}
	/**
	 * ファシリティIDを設定します。<BR>
	 * @param ファシリティID
	 */
	public void setFacilityId(String id) {
		m_facilityId = id;
	}
	/**
	 * ファシリティIDのリストを取得します。<BR>
	 * @return ファシリティID(String)のArrayList
	 */
	public ArrayList<String> getFacilityIdList() {
		return m_facilityIdList;
	}
	/**
	 * ファシリティIDのリストを設定します。<BR>
	 * @param facilityIdList
	 */
	public void setFacilityIdList(ArrayList<String> facilityIdList) {
		this.m_facilityIdList = facilityIdList;
	}
	/**
	 * 監視項目IDを取得します。<BR>
	 * @return 
	 */
	public String getMonitorId() {
		return m_monitorId;
	}
	/**
	 * 監視項目IDを設定します。<BR>
	 * @param monitorId
	 */
	public void setMonitorId(String monitorId) {
		this.m_monitorId = monitorId;
	}
	/**
	 * 監視対象のOIDのリストを取得します。<BR>
	 * @return 監視対象のOIDのリスト
	 */
	public ArrayList<SnmpTrapOidInfo> getOidList() {
		return m_oidList;
	}
	/**
	 * 監視対象のOIDのリストを設定します。<BR>
	 * @param oidList
	 */
	public void setOidList(ArrayList<SnmpTrapOidInfo> oidList) {
		this.m_oidList = oidList;
	}
    /**
     * 監視のチェックモードを取得します。<BR>
     * @return　チェックノード(0:指定したOID 1:マスターすべて　2:未登録OID)
     */
	public int getCheckMode() {
		return m_checkMode;
	}
	/**
	 * 監視のチェックモードを設定します。<BR>
	 * @param checkMode
	 */
	public void setCheckMode(int checkMode){
		m_checkMode = checkMode;
	}
	
    /**
     * カレンダIDを取得します。<BR>
     * @return　カレンダID
     */
	public String getCalendarId() {
		return calendarId;
	}
	
	/**
	 * カレンダIDを設定します。<BR>
	 * @param カレンダID
	 */
	public void setCalendarId(String calendarId) {
		this.calendarId = calendarId;
	}
}
