package com.clustercontrol.accesscontrol.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.HinemosUnknown_Exception;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.InvalidSetting_Exception;
import com.clustercontrol.ws.access.InvalidUserPass_Exception;
import com.clustercontrol.ws.access.UserDuplicate_Exception;
import com.clustercontrol.ws.access.UserFilterInfo;
import com.clustercontrol.ws.access.UserInfo;
import com.clustercontrol.ws.access.UserNotFound_Exception;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class AccessEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( AccessEndpointWrapper.class );

	public static void checkLogin() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception{
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			m_log.info("endpointSetting " + EndpointManager.getAccessEndpoint().size());
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.checkLogin();
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("checkLogin(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static String getUserName() throws HinemosUnknown_Exception, UserNotFound_Exception, InvalidUserPass_Exception, InvalidRole_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.getUserName();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getUserName(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static UserInfo getUserInfo(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.getUserInfo(userId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getUserInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static UserInfo getOwnUserInfo() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.getOwnUserInfo();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getOwnUserInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<UserInfo> getUserInfoList(UserFilterInfo userFilterInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.getUserInfoList(userFilterInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getUserInfoList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addUserInfo(UserInfo userInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserDuplicate_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.addUserInfo(userInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addUserInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyUserInfo(UserInfo userInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyUserInfo(userInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyUserInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteUserInfo(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteUserInfo(userId);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteUserInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean isPermission(String roleName) throws HinemosUnknown_Exception, InvalidUserPass_Exception, InvalidRole_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.isPermission(roleName);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("isPermission(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<String> checkJobManagementUser(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.checkJobManagementUser(userId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("checkJobManagementUser(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void changeOwnPassword(String passwordHash) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.changeOwnPassword(passwordHash);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("changeOwnPassword(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void changePassword(String userId, String passwordHash) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.changePassword(userId, passwordHash);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("changePassword(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static String getVersion() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				return endpoint.getVersion();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getVersion(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
