package com.clustercontrol.collectiverun.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.collectiverun.CollectiveRunEndpoint;
import com.clustercontrol.ws.collectiverun.CollectiveRunInfo;
import com.clustercontrol.ws.collectiverun.CollectiveRunNotFound_Exception;
import com.clustercontrol.ws.collectiverun.CommandInfo;
import com.clustercontrol.ws.collectiverun.CommandNotFound_Exception;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.CommandTypeInfo;
import com.clustercontrol.ws.collectiverun.DetailInfo;
import com.clustercontrol.ws.collectiverun.FacilityNotFound_Exception;
import com.clustercontrol.ws.collectiverun.HashMapInfo;
import com.clustercontrol.ws.collectiverun.ViewListInfo;
import com.clustercontrol.ws.collectiverun.HinemosUnknown_Exception;
import com.clustercontrol.ws.collectiverun.HistoryFilterInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.InvalidUserPass_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.ParameterSelectInfo;
import com.clustercontrol.ws.collectiverun.SessionInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import com.sun.xml.internal.ws.client.ClientTransportException;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class CollectiveRunEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( CollectiveRunEndpointWrapper.class );

	public static void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteMaster(info, parentInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void run(String typeId, CollectiveRunInfo collectiveRunInfo) throws CollectiveRunNotFound_Exception, CommandNotFound_Exception, FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				endpoint.run(typeId, collectiveRunInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("run(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<DetailInfo> getDetailList(String sessionId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getDetailList(sessionId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getDetailList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ViewListInfo getHistoryListAll(int count) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getHistoryListAll(count);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getHistoryListAll(), " + e.getMessage());
				} else {
					m_log.warn("getHistoryListAll(), " + e.getMessage(), e);
				}
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ViewListInfo getHistoryList(HistoryFilterInfo historyFilterInfo, int count) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getHistoryList(historyFilterInfo, count);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getHistoryList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static String getParameterTypeId(String sessionId) throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getParameterTypeId(sessionId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getParameterTypeId(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static TreeItem getTree() throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				TreeItem item = endpoint.getTree();
				setTreeParent(item);
				return item;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getTree(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	private static void setTreeParent(TreeItem item) {
		List<TreeItem> children = item.getChildren();
		for (TreeItem child : children) {
			child.setParent(item);
			setTreeParent(child);
		}
	}

	public static HashMapInfo getTypeHashMap() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getTypeHashMap();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getTypeHashMap(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<String> getTypeStringList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getTypeStringList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getTypeStringList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void updateMaster(ItemInfo info, ItemInfo parentInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				endpoint.updateMaster(info, parentInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("updateMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				endpoint.changeOrder(info1, info2, parentInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("changeOrder(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static SessionInfo getSessionInfo(String sessionId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getSessionInfo(sessionId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getSessionInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static CommandInfo getCommandMst(String commandId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCommandMst(commandId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCommandMst(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static CommandTypeInfo getCommandTypeMst(String typeId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCommandTypeMst(typeId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCommandTypeMst(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<CommandParameterInfo> getCommandParameterMstList(String id) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCommandParameterMstList(id);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCommandParameterMstList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static Integer getParameterType(String id) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getParameterType(id);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getParameterType(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<ParameterSelectInfo> getParameterSelectMstList(String paramId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getParameterSelectMstList(paramId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getParameterSelectMstList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static String getCommandId(String typeId, String name) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
			try {
				CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCommandId(typeId, name);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCommandId(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
