/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.action;

import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[履歴]ビューのフィルタ用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、フィルタ用プロパティを取得する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryFilterProperty {

	/**
	 * マネージャにSessionBean経由でアクセスし、履歴フィルタ用プロパティを取得する
	 * 
	 * @return 履歴フィルタ用プロパティ
	 * 
	 */
	public Property getProperty() {

		Locale locale = Locale.getDefault();

		//開始・再実行日時（自）
		Property m_startFromDate =
			new Property(HistoryFilterPropertyConstant.START_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//開始・再実行日時（至）
		Property m_startToDate =
			new Property(HistoryFilterPropertyConstant.START_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//終了・中断日時（自）
		Property m_endFromDate =
			new Property(HistoryFilterPropertyConstant.END_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//終了・中断日時（至）
		Property m_endToDate =
			new Property(HistoryFilterPropertyConstant.END_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//ジョブID
		Property m_jobId =
			new Property(HistoryFilterPropertyConstant.JOB_ID, Messages.getString("job.id", locale), PropertyConstant.EDITOR_JOB);
		//状態
		Property m_status =
			new Property(HistoryFilterPropertyConstant.STATUS, Messages.getString("run.status", locale), PropertyConstant.EDITOR_SELECT);
		//実行契機種別
		Property m_triggerType =
			new Property(HistoryFilterPropertyConstant.TRIGGER_TYPE, Messages.getString("trigger.type", locale), PropertyConstant.EDITOR_SELECT);
		//実行契機情報
		Property m_triggerInfo =
			new Property(HistoryFilterPropertyConstant.TRIGGER_INFO, Messages.getString("trigger.info", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_128);

		//開始・再実行日時
		Property m_startDate =
			new Property(HistoryFilterPropertyConstant.START_DATE, Messages.getString("start.rerun.time", locale), PropertyConstant.EDITOR_TEXT);
		//終了・中断日時
		Property m_endDate =
			new Property(HistoryFilterPropertyConstant.END_DATE, Messages.getString("end.suspend.time", locale), PropertyConstant.EDITOR_TEXT);
		//実行契機
		Property m_trigger =
			new Property(HistoryFilterPropertyConstant.TRIGGER, Messages.getString("trigger", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化（状態）
		Object statusValues[][] = {
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED },
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED }};

		//値を初期化（実行契機種別）
		Object triggerValues[][] = {
				{ "", JobTriggerTypeConstant.STRING_SCHEDULE, JobTriggerTypeConstant.STRING_MANUAL, JobTriggerTypeConstant.STRING_MONITOR},
				{ "", JobTriggerTypeConstant.STRING_SCHEDULE, JobTriggerTypeConstant.STRING_MANUAL, JobTriggerTypeConstant.STRING_MONITOR}
		};

		m_status.setSelectValues(statusValues);
		m_status.setValue("");
		m_triggerType.setSelectValues(triggerValues);
		m_triggerType.setValue("");

		m_startFromDate.setValue("");
		m_startToDate.setValue("");
		m_endFromDate.setValue("");
		m_endToDate.setValue("");
		m_jobId.setValue("");
		m_triggerInfo.setValue("");

		m_startDate.setValue("");
		m_endDate.setValue("");
		m_trigger.setValue("");

		//変更の可/不可を設定
		m_startFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_startToDate.setModify(PropertyConstant.MODIFY_OK);
		m_endFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_endToDate.setModify(PropertyConstant.MODIFY_OK);
		m_jobId.setModify(PropertyConstant.MODIFY_OK);
		m_status.setModify(PropertyConstant.MODIFY_OK);
		m_triggerType.setModify(PropertyConstant.MODIFY_OK);
		m_triggerInfo.setModify(PropertyConstant.MODIFY_OK);


		m_startDate.setModify(PropertyConstant.MODIFY_NG);
		m_endDate.setModify(PropertyConstant.MODIFY_NG);
		m_trigger.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_startDate);
		property.addChildren(m_endDate);
		property.addChildren(m_jobId);
		property.addChildren(m_status);
		property.addChildren(m_trigger);

		// 開始・再実行日時
		m_startDate.removeChildren();
		m_startDate.addChildren(m_startFromDate);
		m_startDate.addChildren(m_startToDate);

		// 終了・中断日時
		m_endDate.removeChildren();
		m_endDate.addChildren(m_endFromDate);
		m_endDate.addChildren(m_endToDate);

		// 実行契機
		m_trigger.removeChildren();
		m_trigger.addChildren(m_triggerType);
		m_trigger.addChildren(m_triggerInfo);

		return property;
	}
}
