/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.action.GetScheduleTableDefine;
import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.ScheduleListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;

/**
 * ジョブ[スケジュール]ビューの「削除」のクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteScheduleAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( DeleteScheduleAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.DeleteScheduleAction";
	/** ビュー */
	protected IViewPart m_view;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		m_view = view;
	}

	/**
	 * ジョブ[スケジュール]ビューの「削除」が押された場合に、スケジュールを削除します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[スケジュール]ビューから選択されたスケジュールを取得します。</li>
	 * <li>削除の確認ダイアログを表示します。</li>
	 * <li>スケジュールを削除します。</li>
	 * <li>ジョブ[スケジュール]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.jobmanagement.view.ScheduleListView
	 * @see com.clustercontrol.jobmanagement.composite.ScheduleListComposite
	 * @see com.clustercontrol.jobmanagement.action.DeleteSchedule#deleteSchedule(String)
	 */
	@Override
	public void run(IAction action) {
		if (m_view instanceof ScheduleListView) {
			ScheduleListView view = (ScheduleListView) m_view
			.getAdapter(ScheduleListView.class);
			ScheduleListComposite composite = view.getComposite();

			ArrayList item = composite.getSelectItem();
			if (item instanceof ArrayList) {
				String message = Messages.getString("schedule") + "["
				+ (String) item.get(GetScheduleTableDefine.SCHE_ID) + "]"
				+ Messages.getString("message.job.2");
				if (MessageDialog.openQuestion(
						null,
						Messages.getString("confirmed"),
						message)) {
					try {
						JobEndpointWrapper.deleteSchedule(
								(String)item.get(GetScheduleTableDefine.SCHE_ID));
						MessageDialog.openInformation(null, Messages.getString("successful"),
								Messages.getString("message.job.75"));
					} catch (InvalidRole_Exception e) {
						MessageDialog.openInformation(null, Messages.getString("message"),
								Messages.getString("message.accesscontrol.16"));
					} catch (Exception e) {
						m_log.warn("run(), " + e.getMessage(), e);
						MessageDialog.openError(
								null,
								Messages.getString("failed"),
								Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
					}
				}
			}

			view.update();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}