/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.dialog.MaintenanceDialog;
import com.clustercontrol.maintenance.view.MaintenanceListView;
import com.clustercontrol.util.Messages;

/**
 * メンテナンス[一覧]ビューの編集アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MaintenanceModifyAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( MaintenanceModifyAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceModifyAction";

	/** ビュー */
	private IViewPart viewPart;

	@Override
	public void run(IAction action) {
		// 選択アイテムの取得

		MaintenanceListView view = (MaintenanceListView)this.viewPart.getAdapter(MaintenanceListView.class);
		MaintenanceListComposite composite = (MaintenanceListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String maintenanceId = null;
		String typeId = null;
		if(list != null && list.size() > 0){
			maintenanceId = (String) list.get(GetMaintenanceListTableDefine.MAINTENANCE_ID);
		}
		Table table = composite.getTableViewer().getTable();

		//選択アイテムがある場合に、編集ダイアログを表示する
		if(maintenanceId != null){

			try{
				// ダイアログを生成
				MaintenanceDialog dialog = new MaintenanceDialog(this.viewPart.getSite().getShell(), maintenanceId, true);
				// MaintenanceSchedule scheduleList = new GetSchedule().getSchedule(maintenanceId);
				// dialog.setSchedule(scheduleList);
				// ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
				if (dialog.open() == IDialogConstants.OK_ID) {
					int selectIndex = table.getSelectionIndex();
					view.update();
					table.setSelection(selectIndex);
				}
			}
			catch (Exception e1) {
				m_log.warn("run(), " + e1.getMessage(), e1);
			}
		}
		else{
			MessageDialog.openWarning(
					null,
					Messages.getString("warning"),
					Messages.getString("message.maintenance.8"));
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}
	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}
}
