/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.composite.action.MonitorListSelectionChangedListener;
import com.clustercontrol.monitor.view.action.CollectorDisableAction;
import com.clustercontrol.monitor.view.action.CollectorEnableAction;
import com.clustercontrol.monitor.view.action.MonitorDeleteAction;
import com.clustercontrol.monitor.view.action.MonitorDisableAction;
import com.clustercontrol.monitor.view.action.MonitorEnableAction;
import com.clustercontrol.monitor.view.action.MonitorModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * 監視[一覧]ビュークラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MonitorListView extends CommonViewPart {

	/** 監視[一覧]ビューID */
	public static final String ID = "com.clustercontrol.monitor.view.MonitorListView";

	/** 監視設定一覧コンポジット */
	private MonitorListComposite composite = null;

	/** 検索条件 */
	private Property condition = null;

	/**
	 * コンストラクタ
	 */
	public MonitorListView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理<BR>
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		composite = new MonitorListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.composite.setLayoutData(gridData);

		// ボタン（アクション）を制御するリスナーを登録
		this.composite.getTableViewer().addSelectionChangedListener(
				new MonitorListSelectionChangedListener());

		this.update();
	}

	/**
	 * 追加コンポジットを返します。
	 * 
	 * @return 追加コンポジット
	 */
	public Composite getListComposite() {
		return this.composite;
	}

	/**
	 * 検索条件にヒットした監視設定の一覧を表示します。
	 * <p>
	 * 
	 * conditionがnullの場合、全監視設定を表示します。
	 * 
	 * @param condition
	 *            検索条件
	 */
	public void update(Property condition) {
		this.condition = condition;

		this.update();
	}

	/**
	 * ビューを更新します。
	 * <p>
	 * 
	 * 検索条件が事前に設定されている場合、その条件にヒットする監視設定の一覧を 表示します <br>
	 * 検索条件が設定されていない場合は、全監視設定を表示します。
	 */
	public void update() {
		this.composite.update(this.condition);
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(MonitorDeleteAction.ID, selection);
		super.setEnabledAction(MonitorModifyAction.ID, selection);
		super.setEnabledAction(MonitorDisableAction.ID, selection);
		super.setEnabledAction(MonitorEnableAction.ID, selection);
		super.setEnabledAction(CollectorDisableAction.ID, selection);
		super.setEnabledAction(CollectorEnableAction.ID, selection);

		if(num > 0){
			super.setEnabledAction(MonitorDisableAction.ID, true);
			super.setEnabledAction(MonitorEnableAction.ID, true);
			super.setEnabledAction(CollectorDisableAction.ID, true);
			super.setEnabledAction(CollectorEnableAction.ID, true);

			if(num == 1){
				super.setEnabledAction(MonitorDeleteAction.ID, true);
				super.setEnabledAction(MonitorModifyAction.ID, true);
			}else{
				super.setEnabledAction(MonitorDeleteAction.ID, false);
				super.setEnabledAction(MonitorModifyAction.ID, false);
			}
		} else {
			super.setEnabledAction(MonitorDeleteAction.ID, false);
			super.setEnabledAction(MonitorModifyAction.ID, false);
			super.setEnabledAction(MonitorDisableAction.ID, false);
			super.setEnabledAction(MonitorEnableAction.ID, false);
			super.setEnabledAction(CollectorDisableAction.ID, false);
			super.setEnabledAction(CollectorEnableAction.ID, false);
		}
	}
}
