/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.view.action;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.action.NotifyTableDefineNoCheckBox;
import com.clustercontrol.monitor.composite.NotifyListComposite;
import com.clustercontrol.notify.util.NotifyEndpointWrapper;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.Messages;

/**
 * 通知[一覧]ビューの有効アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class NotifyEnableAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( NotifyEnableAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.notify.view.action.NotifyEnableAction";

	/** ビュー */
	private IViewPart viewPart;

	/**
	 * アクション実行
	 */
	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		NotifyListView view = (NotifyListView) this.viewPart.getAdapter(NotifyListView.class);

		NotifyListComposite composite = (NotifyListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		Object [] objs = selection.toArray();

		// 1つも選択されていない場合
		if(objs.length == 0){
			MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.notify.8"));
			return;
		}


		// 1つ以上選択されている場合
		String notifyId = null;
		String[] args;
		ArrayList<String> targetIdList = new ArrayList<String>();
		StringBuffer targetList = new StringBuffer();
		StringBuffer successList = new StringBuffer();
		StringBuffer failureList = new StringBuffer();

		for (int i = 0; i < objs.length; i++) {
			notifyId = (String) ((ArrayList)objs[i]).get(NotifyTableDefineNoCheckBox.NOTIFY_ID);
			targetIdList.add(notifyId);

			targetList.append(notifyId + "\n");
		}

		// 実行確認(NG→終了)
		args = new String[]{ targetList.toString() } ;
		if (!MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				Messages.getString("message.notify.34", args))) {
			return;
		}

		// 実行
		for(String targetId : targetIdList){

			try{
				NotifyEndpointWrapper.setNotifyStatus(targetId, true);
				successList.append(targetId + "\n");
			}catch (Exception e) {
				failureList.append(targetId + "\n");
				m_log.warn("run() setNotifyStatus targetId=" + targetId + ", " + e.getMessage(), e);
			}
		}

		// 成功ダイアログ
		if(successList.length() != 0){
			args = new String[]{ successList.toString() } ;
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					Messages.getString("message.notify.35", args));
		}

		// 失敗ダイアログ
		if(failureList.length() != 0){
			args = new String[]{ failureList.toString() } ;
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.notify.36", args));
		}

		// ビューコンポジット更新
		composite.update();
	}

	/**
	 * 選択時のアクションの有効/無効の判定
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * viewPartの設定
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

}
