/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import com.clustercontrol.util.Messages;

/**
 * ジョブパラメータの定数クラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobParamTypeConstant {
	/** システムパラメータ */
	public static final int TYPE_SYSTEM = 0;

	/** ユーザパラメータ */
	public static final int TYPE_USER = 1;

	/** システムパラメータ */
	public static final String STRING_SYSTEM = Messages.getString("system");

	/** ユーザパラメータ */
	public static final String STRING_USER = Messages.getString("user");

	/**
	 * 種別から文字列に変換します。<BR>
	 * 
	 * @param type
	 * @return
	 */
	public static String typeToString(int type) {
		if (type == TYPE_SYSTEM) {
			return STRING_SYSTEM;
		} else if (type == TYPE_USER) {
			return STRING_USER;
		}
		return "";
	}

	/**
	 * 文字列から種別に変換します。<BR>
	 * 
	 * @param type
	 * @return
	 */
	public static int stringToType(String string) {
		if (string.equals(STRING_SYSTEM)) {
			return TYPE_SYSTEM;
		} else if (string.equals(STRING_USER)) {
			return TYPE_USER;
		}
		return -1;
	}
}