/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Hinemosの一括制御履歴情報を格納するクラス。<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する。
 *
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class HistoryInfo implements Serializable {

	private static final long serialVersionUID = -1472344467663249061L;
	private Integer status = null;
	private String sessionId = null;
	private Long startDate = null;
	private Long endDate = null;
	private String type = null;
	private String name = null;
	private String facilityId = null;
	private String scopeText = null;
	private Integer nodeCount = null;
	private Integer endNormalCount = null;
	private Integer endWarningCount = null;
	private Integer endAbnormalCount = null;
	private Integer waitCount = null;
	private Integer runningCount = null;

	/**
	 * コンストラクタ。
	 */
	public HistoryInfo() {
		super();
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	public Integer getStatus() {
		return status;
	}
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}
	public String getSessionId() {
		return sessionId;
	}
	public void setStartDate(Long startDate) {
		this.startDate = startDate;
	}
	public Long getStartDate() {
		return startDate;
	}
	public void setEndDate(Long endDate) {
		this.endDate = endDate;
	}
	public Long getEndDate() {
		return endDate;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getType() {
		return type;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	public String getFacilityId() {
		return facilityId;
	}
	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}
	public String getScopeText() {
		return scopeText;
	}
	public void setNodeCount(Integer nodeCount) {
		this.nodeCount = nodeCount;
	}
	public Integer getNodeCount() {
		return nodeCount;
	}
	public void setEndNormalCount(Integer endNormalCount) {
		this.endNormalCount = endNormalCount;
	}
	public Integer getEndNormalCount() {
		return endNormalCount;
	}
	public void setEndWarningCount(Integer endWarningCount) {
		this.endWarningCount = endWarningCount;
	}
	public Integer getEndWarningCount() {
		return endWarningCount;
	}
	public void setEndAbnormalCount(Integer endAbnormalCount) {
		this.endAbnormalCount = endAbnormalCount;
	}
	public Integer getEndAbnormalCount() {
		return endAbnormalCount;
	}
	public void setWaitCount(Integer waitCount) {
		this.waitCount = waitCount;
	}
	public Integer getWaitCount() {
		return waitCount;
	}
	public void setRunningCount(Integer runningCount) {
		this.runningCount = runningCount;
	}
	public Integer getRunningCount() {
		return runningCount;
	}

}
