/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.util.ArrayList;

import javax.xml.bind.annotation.XmlType;


/**
 * 一括制御のパラメータ情報を保持するクラスです。<BR>
 * 一括制御[作成・変更]ダイアログから設定します。
 * 
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class ParameterInfo extends ItemInfo {
	private static final long serialVersionUID = -8291998799865546000L;

	/** パラメータID */
	private String id;

	/** 接頭語 */
	private Integer paramType = new Integer(0);

	/** 選択されたパラメータ */
	private ArrayList<ParameterSelectInfo> selectMsts = new ArrayList<ParameterSelectInfo>();

	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return
	 */
	public Integer getParamType() {
		return paramType;
	}

	/**
	 * @param paramType
	 */
	public void setParamType(Integer paramType) {
		this.paramType = paramType;
	}
	/**
	 * @return
	 */
	public ArrayList<ParameterSelectInfo> getSelectMsts() {
		return selectMsts;
	}

	/**
	 * @param selectMsts
	 */
	public void setSelectMsts(ArrayList<ParameterSelectInfo> selectMsts) {
		this.selectMsts = selectMsts;
	}

	public void addSelectMst(ParameterSelectInfo mst){
		this.selectMsts.add(mst);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		ParameterInfo clone = (ParameterInfo)super.clone();

		clone.setId(this.getId());
		clone.setParamType(this.getParamType());

		return clone;
	}
}