/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.bean;

import java.util.ArrayList;

import com.clustercontrol.collectiverun.bean.HistoryInfo;
import com.clustercontrol.monitor.bean.EventDataInfo;

/**
 * 
 * イベント・一括制御履歴一覧情報を保持するクラス<BR>
 * イベント・一括制御履歴の一覧は、それぞれ下記のオブジェクトが格納されたArrayListである<BR>
 * 仮想化操作の一覧情報も保持する<BR>
 * 
 * <li> イベント：com.clustercontrol.monitor.bean.EventDataInfo
 * <li> ステータス：com.clustercontrol.collectiverun.bean.HistoryInfo
 * 
 * @version 3.0
 * @since 2.1.1
 */
public class ViewListInfo implements java.io.Serializable{

	private static final long serialVersionUID = 859993588207224113L;

	private Integer critical = new Integer(0);			//重要度:危険数
	private Integer warning = new Integer(0);			//重要度:警告数
	private Integer info = new Integer(0);				//重要度:通知数
	private Integer unKnown = new Integer(0);			//重要度:不明数
	private Integer total = new Integer(0);			//合計数

	/**
	 *
	 * イベント一覧
	 * 一括制御履歴一覧
	 * 
	 * @see com.clustercontrol.monitor.bean.EventDataInfo
	 * @see com.clustercontrol.collectiverun.bean.HistoryInfo
	 * 
	 */
	private ArrayList<EventDataInfo> eventList;
	private ArrayList<HistoryInfo> collectiverunHistoryList;


	/**
	 * コンストラクタ。
	 */
	public ViewListInfo() {
		super();
	}

	/**
	 * @return
	 */
	public Integer getCritical() {
		return critical;
	}

	/**
	 * @param critical
	 */
	public void setCritical(Integer critical) {
		this.critical = critical;
	}

	public ArrayList<EventDataInfo> getEventList() {
		return eventList;
	}

	public void setEventList(ArrayList<EventDataInfo> eventList) {
		this.eventList = eventList;
	}

	public ArrayList<HistoryInfo> getCollectiverunHistoryList() {
		return collectiverunHistoryList;
	}

	public void setCollectiverunHistoryList(
			ArrayList<HistoryInfo> collectiverunHistoryList) {
		this.collectiverunHistoryList = collectiverunHistoryList;
	}

	/**
	 * @return
	 */
	public Integer getInfo() {
		return info;
	}

	/**
	 * @param info
	 */
	public void setInfo(Integer info) {
		this.info = info;
	}

	/**
	 * @return
	 */
	public Integer getTotal() {
		return total;
	}

	/**
	 * @param total
	 */
	public void setTotal(Integer total) {
		this.total = total;
	}

	/**
	 * @return
	 */
	public Integer getUnKnown() {
		return unKnown;
	}

	/**
	 * @param unKnown
	 */
	public void setUnKnown(Integer unKnown) {
		this.unKnown = unKnown;
	}

	/**
	 * @return
	 */
	public Integer getWarning() {
		return warning;
	}

	/**
	 * @param warning
	 */
	public void setWarning(Integer warning) {
		this.warning = warning;
	}
}